/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class LiteShapeTest
extends TestCase {
    private URL base = ((Object)((Object)this)).getClass().getResource("testData/");

    public LiteShapeTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LiteShapeTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LiteShapeTest.class);
        return suite;
    }

    public void testLineShape() throws TransformException, FactoryException {
        GeometryFactory geomFac = new GeometryFactory();
        LineString lineString = this.makeSampleLineString(geomFac, 0.0, 0.0);
        AffineTransform affineTransform = new AffineTransform();
        LiteShape lineShape = new LiteShape((Geometry)lineString, affineTransform, false);
        LiteShapeTest.assertFalse((boolean)lineShape.contains(0.0, 0.0));
        LiteShapeTest.assertTrue((boolean)lineShape.contains(60.0, 60.0));
        LiteShapeTest.assertFalse((boolean)lineShape.contains(50.0, 50.0, 10.0, 10.0));
        LiteShapeTest.assertTrue((boolean)lineShape.contains((Point2D)new Point(60, 60)));
        LiteShapeTest.assertFalse((boolean)lineShape.contains((Rectangle2D)new Rectangle2D.Float(50.0f, 50.0f, 10.0f, 10.0f)));
        LiteShapeTest.assertTrue((boolean)lineShape.getBounds2D().equals(new Rectangle2D.Double(50.0, 50.0, 80.0, 250.0)));
        LiteShapeTest.assertTrue((boolean)lineShape.getBounds().equals(new Rectangle(50, 50, 80, 250)));
        LiteShapeTest.assertTrue((boolean)lineShape.intersects(0.0, 0.0, 100.0, 100.0));
        LiteShapeTest.assertTrue((boolean)lineShape.intersects((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0)));
        LiteShapeTest.assertFalse((boolean)lineShape.intersects(55.0, 55.0, 3.0, 100.0));
        LiteShapeTest.assertFalse((boolean)lineShape.intersects((Rectangle2D)new Rectangle2D.Double(55.0, 55.0, 3.0, 100.0)));
    }

    public void testLineShape2() throws TransformException, FactoryException {
        GeometryFactory geomFac = new GeometryFactory();
        LineString lineString = this.makeSampleLineString(geomFac, 0.0, 0.0);
        LinearTransform transform = ProjectiveTransform.create((AffineTransform)new AffineTransform());
        Decimator decimator = new Decimator((MathTransform)transform);
        LiteShape2 lineShape = new LiteShape2((Geometry)lineString, (MathTransform)transform, decimator, false);
        LiteShapeTest.assertFalse((boolean)lineShape.contains(0.0, 0.0));
        LiteShapeTest.assertTrue((boolean)lineShape.contains(60.0, 60.0));
        LiteShapeTest.assertFalse((boolean)lineShape.contains(50.0, 50.0, 10.0, 10.0));
        LiteShapeTest.assertTrue((boolean)lineShape.contains((Point2D)new Point(60, 60)));
        LiteShapeTest.assertFalse((boolean)lineShape.contains((Rectangle2D)new Rectangle2D.Float(50.0f, 50.0f, 10.0f, 10.0f)));
        LiteShapeTest.assertTrue((boolean)lineShape.getBounds2D().equals(new Rectangle2D.Double(50.0, 50.0, 80.0, 250.0)));
        LiteShapeTest.assertTrue((boolean)lineShape.getBounds().equals(new Rectangle(50, 50, 80, 250)));
        LiteShapeTest.assertTrue((boolean)lineShape.intersects(0.0, 0.0, 100.0, 100.0));
        LiteShapeTest.assertTrue((boolean)lineShape.intersects((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0)));
        LiteShapeTest.assertFalse((boolean)lineShape.intersects(55.0, 55.0, 3.0, 100.0));
        LiteShapeTest.assertFalse((boolean)lineShape.intersects((Rectangle2D)new Rectangle2D.Double(55.0, 55.0, 3.0, 100.0)));
    }

    public void testPolygonShape() throws TransformException, FactoryException {
        GeometryFactory geomFac = new GeometryFactory();
        Polygon polygon = this.makeSamplePolygon(geomFac, 0.0, 0.0);
        LiteShape2 lineShape = new LiteShape2((Geometry)polygon, (MathTransform)ProjectiveTransform.create((AffineTransform)new AffineTransform()), new Decimator((MathTransform)ProjectiveTransform.create((AffineTransform)new AffineTransform())), false);
        LiteShapeTest.assertFalse((boolean)lineShape.contains(0.0, 0.0));
        LiteShapeTest.assertTrue((boolean)lineShape.contains(100.0, 100.0));
        LiteShapeTest.assertFalse((boolean)lineShape.contains(50.0, 50.0, 10.0, 10.0));
        LiteShapeTest.assertTrue((boolean)lineShape.contains(100.0, 100.0, 10.0, 10.0));
        LiteShapeTest.assertTrue((boolean)lineShape.contains((Point2D)new Point(70, 90)));
        LiteShapeTest.assertFalse((boolean)lineShape.contains((Rectangle2D)new Rectangle2D.Float(50.0f, 50.0f, 10.0f, 10.0f)));
        LiteShapeTest.assertTrue((boolean)lineShape.getBounds2D().equals(new Rectangle2D.Double(60.0, 70.0, 70.0, 50.0)));
        LiteShapeTest.assertTrue((boolean)lineShape.getBounds().equals(new Rectangle(60, 70, 70, 50)));
        LiteShapeTest.assertTrue((boolean)lineShape.intersects(0.0, 0.0, 100.0, 100.0));
        LiteShapeTest.assertTrue((boolean)lineShape.intersects((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0)));
        LiteShapeTest.assertFalse((boolean)lineShape.intersects(55.0, 55.0, 3.0, 100.0));
        LiteShapeTest.assertFalse((boolean)lineShape.intersects((Rectangle2D)new Rectangle2D.Double(55.0, 55.0, 3.0, 100.0)));
    }

    public void testCloning() throws TransformException, FactoryException {
        LiteCoordinateSequenceFactory csFac = new LiteCoordinateSequenceFactory();
        GeometryFactory geomFac = new GeometryFactory((CoordinateSequenceFactory)csFac);
        CoordinateSequence cs = csFac.create(4, 2);
        cs.setOrdinate(0, 0, 10.0);
        cs.setOrdinate(0, 1, 10.0);
        cs.setOrdinate(1, 0, 12.0);
        cs.setOrdinate(1, 1, 12.0);
        cs.setOrdinate(2, 0, 14.0);
        cs.setOrdinate(2, 1, 12.0);
        cs.setOrdinate(3, 0, 30.0);
        cs.setOrdinate(3, 1, 10.0);
        LineString ls = geomFac.createLineString(cs);
        LineString copy = (LineString)ls.clone();
        LiteShape2 ltCloning = new LiteShape2((Geometry)ls, (MathTransform)ProjectiveTransform.create((AffineTransform)AffineTransform.getScaleInstance(10.0, 10.0)), new Decimator(4.0, 4.0), true);
        LiteShapeTest.assertTrue((boolean)ls.equals((Geometry)copy));
        LiteShape2 ltNotCloning = new LiteShape2((Geometry)ls, (MathTransform)ProjectiveTransform.create((AffineTransform)AffineTransform.getScaleInstance(10.0, 10.0)), new Decimator(4.0, 4.0), true, false);
        LiteShapeTest.assertFalse((boolean)ls.equals((Geometry)copy));
    }

    private LineString makeSampleLineString(GeometryFactory geomFac, double xoff, double yoff) {
        Coordinate[] linestringCoordinates = new Coordinate[]{new Coordinate(50.0 + xoff, 50.0 + yoff), new Coordinate(60.0 + xoff, 50.0 + yoff), new Coordinate(60.0 + xoff, 60.0 + yoff), new Coordinate(70.0 + xoff, 60.0 + yoff), new Coordinate(70.0 + xoff, 70.0 + yoff), new Coordinate(80.0 + xoff, 70.0 + yoff), new Coordinate(80.0 + xoff, 80.0 + yoff), new Coordinate(130.0 + xoff, 300.0 + yoff)};
        LineString line = geomFac.createLineString(linestringCoordinates);
        return line;
    }

    private Polygon makeSamplePolygon(GeometryFactory geomFac, double xoff, double yoff) {
        Coordinate[] polygonCoordinates = new Coordinate[]{new Coordinate(70.0 + xoff, 70.0 + yoff), new Coordinate(60.0 + xoff, 90.0 + yoff), new Coordinate(60.0 + xoff, 110.0 + yoff), new Coordinate(70.0 + xoff, 120.0 + yoff), new Coordinate(90.0 + xoff, 110.0 + yoff), new Coordinate(110.0 + xoff, 120.0 + yoff), new Coordinate(130.0 + xoff, 110.0 + yoff), new Coordinate(130.0 + xoff, 90.0 + yoff), new Coordinate(110.0 + xoff, 70.0 + yoff), new Coordinate(70.0 + xoff, 70.0 + yoff)};
        try {
            LinearRing ring = geomFac.createLinearRing(polygonCoordinates);
            Polygon polyg = geomFac.createPolygon(ring, null);
            return polyg;
        }
        catch (TopologyException te) {
            LiteShapeTest.fail((String)("Error creating sample polygon for testing " + (Object)((Object)te)));
            return null;
        }
    }
}

