/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.synch;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.VersioningDataStore;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.postgis.ModifiedFeatureIds;
import org.geotools.data.postgis.VersionedPostgisDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedPostgisDataStore
implements VersioningDataStore {
    static final String TBL_SYNCH_UNITS = "synch_units";
    static final String TBL_SYNCH_TABLES = "synch_tables";
    static final String TBL_SYNCH_UNIT_TABLES = "synch_unit_tables";
    static final String TBL_SYNCH_OUTSTANDING = "synch_outstanding";
    static final String TBL_SYNCH_CONFLICTS = "synch_conflicts";
    static final String TBL_SYNCH_HISTORY = "synch_history";
    VersionedPostgisDataStore dataStore = null;

    public SynchronizedPostgisDataStore(DataSource dataSource, String schema, String namespace, int optimizeMode) throws IOException {
        this.dataStore = new VersionedPostgisDataStore(dataSource, schema, namespace, optimizeMode);
    }

    public SynchronizedPostgisDataStore(DataSource dataSource, String schema, String namespace) throws IOException {
        this.dataStore = new VersionedPostgisDataStore(dataSource, schema, namespace);
    }

    public SynchronizedPostgisDataStore(DataSource dataSource, String namespace) throws IOException {
        this.dataStore = new VersionedPostgisDataStore(dataSource, namespace);
    }

    public SynchronizedPostgisDataStore(DataSource dataSource) throws IOException {
        this.dataStore = new VersionedPostgisDataStore(dataSource);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.dataStore.createSchema(featureType);
    }

    public void dispose() {
        this.dataStore.dispose();
    }

    public boolean equals(Object obj) {
        return this.dataStore.equals(obj);
    }

    public Connection getConnection(Transaction t) throws IOException {
        return this.dataStore.getConnection(t);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction trans) throws IOException {
        return this.dataStore.getFeatureReader(query, trans);
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.dataStore.getFeatureSource(typeName);
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        return this.dataStore.getFeatureSource(typeName);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        return this.dataStore.getFeatureWriter(typeName, filter, transaction);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.dataStore.getFeatureWriter(typeName, transaction);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        return this.dataStore.getFeatureWriterAppend(typeName, transaction);
    }

    public FIDMapper getFIDMapper(String tableName) throws IOException {
        return this.dataStore.getFIDMapper(tableName);
    }

    public ServiceInfo getInfo() {
        return this.dataStore.getInfo();
    }

    public long getLastRevision() throws IOException {
        return this.dataStore.getLastRevision();
    }

    public LockingManager getLockingManager() {
        return this.dataStore.getLockingManager();
    }

    public ModifiedFeatureIds getModifiedFeatureFIDs(String typeName, String version1, String version2, Filter originalFilter, String[] users, Transaction transaction) throws IOException {
        return this.dataStore.getModifiedFeatureFIDs(typeName, version1, version2, originalFilter, users, transaction);
    }

    public String[] getModifiedFeatureTypes(String version1, String version2) throws IOException {
        return this.dataStore.getModifiedFeatureTypes(version1, version2);
    }

    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add((Name)new NameImpl(typeName));
        }
        return names;
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        String st = name.getLocalPart();
        if (st.equals(TBL_SYNCH_UNITS) || st.equals(TBL_SYNCH_TABLES) || st.equals(TBL_SYNCH_UNIT_TABLES) || st.equals(TBL_SYNCH_OUTSTANDING) || st.equals(TBL_SYNCH_CONFLICTS) || st.equals(TBL_SYNCH_HISTORY)) {
            throw new IOException(st + " is a protected type.  Hands off.");
        }
        return this.dataStore.getSchema(name);
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        if (typeName.equals(TBL_SYNCH_UNITS) || typeName.equals(TBL_SYNCH_TABLES) || typeName.equals(TBL_SYNCH_UNIT_TABLES) || typeName.equals(TBL_SYNCH_OUTSTANDING) || typeName.equals(TBL_SYNCH_CONFLICTS) || typeName.equals(TBL_SYNCH_HISTORY)) {
            throw new IOException(typeName + " is a protected type.  Hands off.");
        }
        return this.dataStore.getSchema(typeName);
    }

    public String[] getTypeNames() throws IOException {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(this.dataStore.getTypeNames()));
        names.remove(TBL_SYNCH_UNITS);
        names.remove(TBL_SYNCH_TABLES);
        names.remove(TBL_SYNCH_UNIT_TABLES);
        names.remove(TBL_SYNCH_OUTSTANDING);
        names.remove(TBL_SYNCH_HISTORY);
        names.remove(TBL_SYNCH_CONFLICTS);
        return names.toArray(new String[names.size()]);
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getView(Query query) throws IOException, SchemaException {
        return this.dataStore.getView(query);
    }

    public int hashCode() {
        return this.dataStore.hashCode();
    }

    @Override
    public boolean isVersioned(String typeName) throws IOException {
        return this.dataStore.isVersioned(typeName);
    }

    public boolean isVersionedFeatureCollection(String typeName) throws IOException {
        return this.dataStore.isVersionedFeatureCollection(typeName);
    }

    public void setLooseBbox(boolean enabled) {
        this.dataStore.setLooseBbox(enabled);
    }

    @Override
    public void setVersioned(String typeName, boolean versioned, String author, String message) throws IOException {
        this.dataStore.setVersioned(typeName, versioned, author, message);
    }

    public void setWKBEnabled(boolean enabled) {
        this.dataStore.setWKBEnabled(enabled);
    }

    public String toString() {
        return this.dataStore.toString();
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.dataStore.updateSchema(typeName, featureType);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        this.dataStore.updateSchema(typeName, featureType);
    }
}

