/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.jdbc.fidmapper.DefaultFIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.data.postgis.VersionedPostgisDataStore;
import org.geotools.data.postgis.fidmapper.PostGISAutoIncrementFIDMapper;
import org.geotools.data.postgis.fidmapper.VersionedAutoincrementFIDMapper;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapper;
import org.geotools.data.postgis.fidmapper.VersionedFeatureCollectionFidMapper;
import org.geotools.data.postgis.fidmapper.VersionedMulticolumnFIDMapper;
import org.geotools.data.postgis.fidmapper.VersionedUUIDFIDMapper;

public class VersionedFIDMapperFactory
extends DefaultFIDMapperFactory {
    Set versionedTypes = new HashSet();
    private FIDMapperFactory unversionedFactory;

    public VersionedFIDMapperFactory(FIDMapperFactory unversionedFactory) {
        this.unversionedFactory = unversionedFactory;
        this.returnFIDColumnsAsAttributes = true;
        this.returningTypedFIDMapper = false;
    }

    public void setVersionedTypes(String[] versionedTypes) {
        this.versionedTypes.clear();
        this.versionedTypes.addAll(Arrays.asList(versionedTypes));
    }

    public FIDMapper getMapper(String catalog, String schema, String tableName, Connection connection) throws IOException {
        if ("changesets".equals(tableName)) {
            PostGISAutoIncrementFIDMapper mapper = new PostGISAutoIncrementFIDMapper("changesets", "revision", 2, true);
            return new TypedFIDMapper((FIDMapper)mapper, "changesets");
        }
        if (!this.versionedTypes.contains(tableName)) {
            if (tableName.endsWith("_vfc_view")) {
                try {
                    String otn = VersionedPostgisDataStore.getVFCTableName(tableName);
                    VersionedFIDMapper mapper = (VersionedFIDMapper)this.getMapper(catalog, schema, otn, connection);
                    return new VersionedFeatureCollectionFidMapper(mapper);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return this.unversionedFactory.getMapper(catalog, schema, tableName, connection);
        }
        DefaultFIDMapperFactory.ColumnInfo[] colInfos = this.getPkColumnInfo(catalog, schema, tableName, connection);
        if (colInfos.length <= 1) {
            throw new IOException("Versioned type (" + tableName + ") with a primary key with less than 2 columns," + " this cannot be, there's a error");
        }
        if (colInfos.length == 2) {
            return this.buildSingleColumnVersionedFidMapper(schema, tableName, connection, colInfos);
        }
        return this.buildMultiColumnFIDMapper(schema, tableName, connection, colInfos);
    }

    protected FIDMapper buildSingleColumnVersionedFidMapper(String schema, String tableName, Connection connection, DefaultFIDMapperFactory.ColumnInfo[] colInfos) {
        DefaultFIDMapperFactory.ColumnInfo col = colInfos[1];
        if (col.isAutoIncrement() && colInfos.length == 2) {
            return new VersionedAutoincrementFIDMapper(schema, tableName, col.colName, col.dataType, colInfos[0].decimalDigits);
        }
        if ("uuid".equals(col.getTypeName())) {
            return new VersionedUUIDFIDMapper(schema, tableName, col.getColName(), col.dataType, col.size);
        }
        if (this.isIntegralType(col.dataType)) {
            return this.buildMultiColumnFIDMapper(schema, tableName, connection, colInfos);
        }
        return this.buildMultiColumnFIDMapper(schema, tableName, connection, colInfos);
    }

    protected FIDMapper buildMultiColumnFIDMapper(String schema, String tableName, Connection connection, DefaultFIDMapperFactory.ColumnInfo[] colInfos) {
        String[] colNames = new String[colInfos.length];
        int[] colTypes = new int[colInfos.length];
        int[] colSizes = new int[colInfos.length];
        int[] colDecimalDigits = new int[colInfos.length];
        boolean[] autoIncrement = new boolean[colInfos.length];
        for (int i = 0; i < colInfos.length; ++i) {
            DefaultFIDMapperFactory.ColumnInfo ci = colInfos[i];
            colNames[i] = ci.colName;
            colTypes[i] = ci.dataType;
            colSizes[i] = ci.size;
            colDecimalDigits[i] = ci.decimalDigits;
            autoIncrement[i] = ci.autoIncrement;
        }
        return new VersionedMulticolumnFIDMapper(schema, tableName, colNames, colTypes, colSizes, colDecimalDigits, autoIncrement);
    }
}

