/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.literal;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Map;
import org.geotools.process.ProcessFactory;
import org.geotools.process.impl.AbstractProcess;
import org.geotools.process.literal.FeatureBufferFactory;
import org.geotools.text.Text;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureBufferProcess
extends AbstractProcess {
    private boolean started = false;

    public FeatureBufferProcess(FeatureBufferFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.started) {
            throw new IllegalStateException("Process can only be run once");
        }
        this.started = true;
        if (null == monitor) {
            monitor = new NullProgressListener();
        }
        try {
            monitor.started();
            monitor.setTask(Text.text("Fetching arguments"));
            monitor.progress(10.0f);
            Feature input_a = (Feature)input.get(FeatureBufferFactory.INPUT_A.key);
            Double input_b = (Double)input.get(FeatureBufferFactory.INPUT_B.key);
            monitor.setTask(Text.text("Buffering Feature"));
            monitor.progress(25.0f);
            for (Property prop : input_a.getProperties()) {
                if (monitor.isCanceled()) {
                    Map<String, Object> map = null;
                    return map;
                }
                if (!Geometry.class.equals((Object)prop.getType().getBinding())) continue;
                Geometry buffered = ((Geometry)prop.getValue()).buffer(input_b.doubleValue());
                prop.setValue((Object)buffered);
            }
            monitor.setTask(Text.text("Encoding result"));
            monitor.progress(90.0f);
            result.put(FeatureBufferFactory.RESULT.key, input_a);
            monitor.complete();
        }
        catch (Exception e) {
            monitor.exceptionOccurred((Throwable)e);
            Map<String, Object> map = null;
            return map;
        }
        finally {
            monitor.dispose();
        }
        return result;
    }

    public ProcessFactory getFactory() {
        return this.factory;
    }
}

