/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImage;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.feature.AbstractFeatureCollectionProcess;
import org.geotools.process.feature.AbstractFeatureCollectionProcessFactory;
import org.geotools.process.raster.VectorToRasterException;
import org.geotools.process.raster.VectorToRasterFactory;
import org.geotools.referencing.CRS;
import org.geotools.util.NullProgressListener;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorToRasterProcess
extends AbstractFeatureCollectionProcess {
    private static final int COORD_GRID_CHUNK_SIZE = 1000;
    private TransferType transferType;
    private ValueSource valueSource;
    GridCoverage2D result;
    private Number minAttValue;
    private Number maxAttValue;
    private float nodataValue;
    private ReferencedEnvelope extent;
    private GridGeometry2D gridGeom;
    private Geometry extentGeometry;
    private int[] coordGridX = new int[1000];
    private int[] coordGridY = new int[1000];
    TiledImage image;
    Graphics2D graphics;

    public VectorToRasterProcess(VectorToRasterFactory factory) {
        super(factory);
    }

    public static GridCoverage2D process(SimpleFeatureCollection features, Object attribute, Dimension gridDim, org.opengis.geometry.Envelope bounds, String covName, ProgressListener monitor) throws VectorToRasterException {
        VectorToRasterFactory factory = new VectorToRasterFactory();
        VectorToRasterProcess process = factory.create();
        return process.convert(features, attribute, gridDim, bounds, covName, monitor);
    }

    @Override
    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) throws VectorToRasterException {
        SimpleFeatureCollection features = (SimpleFeatureCollection)input.get(AbstractFeatureCollectionProcessFactory.FEATURES.key);
        String attributeStr = (String)input.get(VectorToRasterFactory.ATTRIBUTE.key);
        Expression attribute = null;
        try {
            attribute = ECQL.toExpression((String)attributeStr);
        }
        catch (CQLException e) {
            throw new VectorToRasterException((Exception)((Object)e));
        }
        int w = (Integer)input.get(VectorToRasterFactory.RASTER_WIDTH.key);
        int h = (Integer)input.get(VectorToRasterFactory.RASTER_HEIGHT.key);
        Dimension gridDim = new Dimension(w, h);
        ReferencedEnvelope env = (ReferencedEnvelope)input.get(VectorToRasterFactory.BOUNDS.key);
        String title = (String)input.get(VectorToRasterFactory.TITLE.key);
        if (title == null) {
            title = "raster";
        }
        GridCoverage2D cov = this.convert(features, attribute, gridDim, (org.opengis.geometry.Envelope)env, title, monitor);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(VectorToRasterFactory.RESULT.key, cov);
        return results;
    }

    @Override
    protected void processFeature(SimpleFeature feature, Map<String, Object> input) throws Exception {
        Object attribute = input.get(VectorToRasterFactory.ATTRIBUTE.key);
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (geometry.intersects(this.extentGeometry)) {
            Number value = this.getFeatureValue(feature, attribute);
            switch (this.transferType) {
                case FLOAT: {
                    if (this.minAttValue == null) {
                        this.minAttValue = this.maxAttValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (Float.compare(value.floatValue(), this.minAttValue.floatValue()) < 0) {
                        this.minAttValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (Float.compare(value.floatValue(), this.maxAttValue.floatValue()) <= 0) break;
                    this.maxAttValue = Float.valueOf(value.floatValue());
                    break;
                }
                case INTEGRAL: {
                    if (this.minAttValue == null) {
                        this.minAttValue = this.maxAttValue = Integer.valueOf(value.intValue());
                        break;
                    }
                    if (value.intValue() < this.minAttValue.intValue()) {
                        this.minAttValue = value.intValue();
                        break;
                    }
                    if (value.intValue() <= this.maxAttValue.intValue()) break;
                    this.maxAttValue = value.intValue();
                }
            }
            this.graphics.setColor(this.valueToColor(value));
            Geometries geomType = Geometries.get((Geometry)geometry);
            switch (geomType) {
                case MULTIPOLYGON: 
                case MULTILINESTRING: 
                case MULTIPOINT: {
                    int numGeom = geometry.getNumGeometries();
                    for (int i = 0; i < numGeom; ++i) {
                        Geometry geomN = geometry.getGeometryN(i);
                        this.drawGeometry(Geometries.get((Geometry)geomN), geomN);
                    }
                    break;
                }
                case POLYGON: 
                case LINESTRING: 
                case POINT: {
                    this.drawGeometry(geomType, geometry);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported geometry type: " + geomType.getName());
                }
            }
        }
    }

    private Number getFeatureValue(SimpleFeature feature, Object attribute) {
        Class rtnType;
        Class clazz = rtnType = this.transferType == TransferType.FLOAT ? Float.class : Integer.class;
        if (this.valueSource == ValueSource.PROPERTY_NAME) {
            return (Number)rtnType.cast(feature.getAttribute((String)attribute));
        }
        return (Number)((Expression)attribute).evaluate((Object)feature, rtnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverage2D convert(SimpleFeatureCollection features, Object attribute, Dimension gridDim, org.opengis.geometry.Envelope bounds, String covName, ProgressListener monitor) throws VectorToRasterException {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        this.initialize(features, bounds, attribute, gridDim);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(VectorToRasterFactory.ATTRIBUTE.key, attribute);
        monitor.setTask((InternationalString)new SimpleInternationalString("Rasterizing features..."));
        float scale = 100.0f / (float)features.size();
        monitor.started();
        SimpleFeatureIterator fi = features.features();
        try {
            int counter = 0;
            while (fi.hasNext()) {
                try {
                    this.processFeature((SimpleFeature)fi.next(), params);
                }
                catch (Exception e) {
                    monitor.exceptionOccurred((Throwable)e);
                }
                monitor.progress(scale * (float)counter++);
            }
        }
        finally {
            features.close((FeatureIterator)fi);
        }
        monitor.complete();
        this.flattenImage();
        GridCoverageFactory gcf = new GridCoverageFactory();
        return gcf.create((CharSequence)covName, (RenderedImage)this.image, (org.opengis.geometry.Envelope)this.extent);
    }

    private void initialize(SimpleFeatureCollection features, org.opengis.geometry.Envelope bounds, Object attribute, Dimension gridDim) throws VectorToRasterException {
        if (attribute instanceof String) {
            String propName = (String)attribute;
            AttributeDescriptor attDesc = ((SimpleFeatureType)features.getSchema()).getDescriptor(propName);
            if (attDesc == null) {
                throw new VectorToRasterException(propName + " not found");
            }
            Class attClass = attDesc.getType().getBinding();
            if (!Number.class.isAssignableFrom(attClass)) {
                throw new VectorToRasterException(propName + " is not numeric");
            }
            if (Float.class.isAssignableFrom(attClass)) {
                this.transferType = TransferType.FLOAT;
            } else if (Double.class.isAssignableFrom(attClass)) {
                this.transferType = TransferType.FLOAT;
                Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing double feature values to float raster values");
            } else if (Long.class.isAssignableFrom(attClass)) {
                this.transferType = TransferType.INTEGRAL;
                Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing long feature values to int raster values");
            } else {
                this.transferType = TransferType.INTEGRAL;
            }
            this.valueSource = ValueSource.PROPERTY_NAME;
        } else if (attribute instanceof Expression) {
            this.valueSource = ValueSource.EXPRESSION;
            SimpleFeature feature = (SimpleFeature)features.features().next();
            Object value = ((Expression)attribute).evaluate((Object)feature);
            if (value.getClass().equals(String.class)) {
                Boolean hasException = false;
                try {
                    Integer.valueOf((String)value);
                    this.transferType = TransferType.INTEGRAL;
                }
                catch (NumberFormatException e) {
                    hasException = true;
                }
                if (hasException.booleanValue()) {
                    hasException = false;
                    try {
                        Float.valueOf((String)value);
                        this.transferType = TransferType.FLOAT;
                    }
                    catch (NumberFormatException e) {
                        hasException = true;
                    }
                }
                if (hasException.booleanValue()) {
                    throw new VectorToRasterException(((Expression)attribute).toString() + " does not evaluate to a number");
                }
            } else {
                if (!Number.class.isAssignableFrom(value.getClass())) {
                    throw new VectorToRasterException(((Expression)attribute).toString() + " does not evaluate to a number");
                }
                if (Float.class.isAssignableFrom(value.getClass())) {
                    this.transferType = TransferType.FLOAT;
                } else if (Double.class.isAssignableFrom(value.getClass())) {
                    this.transferType = TransferType.FLOAT;
                    Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing double feature values to float raster values");
                } else if (Long.class.isAssignableFrom(value.getClass())) {
                    this.transferType = TransferType.INTEGRAL;
                    Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing long feature values to int raster values");
                } else {
                    this.transferType = TransferType.INTEGRAL;
                }
            }
        } else {
            throw new VectorToRasterException("value attribute must be a feature property nameor an org.opengis.filter.expression.Expression object");
        }
        this.maxAttValue = null;
        this.minAttValue = null;
        this.setBounds(features, bounds, gridDim);
        this.createImage(gridDim);
        this.gridGeom = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, gridDim.width, gridDim.height), (org.opengis.geometry.Envelope)this.extent);
    }

    private void setBounds(SimpleFeatureCollection features, org.opengis.geometry.Envelope bounds, Dimension gridDim) throws VectorToRasterException {
        ReferencedEnvelope featureBounds = features.getBounds();
        if (bounds != null) {
            ReferencedEnvelope trEnv;
            ReferencedEnvelope inputBounds = new ReferencedEnvelope(bounds);
            CoordinateReferenceSystem featuresCRS = featureBounds.getCoordinateReferenceSystem();
            CoordinateReferenceSystem envCRS = bounds.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)envCRS, (Object)featuresCRS)) {
                try {
                    trEnv = inputBounds.transform(featuresCRS, true);
                }
                catch (Exception tex) {
                    throw new VectorToRasterException(tex);
                }
            } else {
                trEnv = inputBounds;
            }
            if (trEnv.covers((Envelope)features.getBounds())) {
                this.extent = trEnv;
            } else {
                Envelope common = trEnv.intersection((Envelope)features.getBounds());
                if (common == null || common.isNull()) {
                    throw new VectorToRasterException("Features do not lie within the requested rasterizing bounds");
                }
                this.extent = new ReferencedEnvelope(common, featuresCRS);
            }
        } else {
            this.extent = featureBounds;
        }
        GeometryFactory gf = new GeometryFactory();
        this.extentGeometry = gf.toGeometry((Envelope)this.extent);
    }

    private void createImage(Dimension gridDim) {
        ColorModel cm = ColorModel.getRGBdefault();
        SampleModel sm = cm.createCompatibleSampleModel(gridDim.width, gridDim.height);
        this.image = new TiledImage(0, 0, gridDim.width, gridDim.height, 0, 0, sm, cm);
        this.graphics = this.image.createGraphics();
        this.graphics.setPaintMode();
        this.graphics.setComposite(AlphaComposite.Src);
    }

    private void flattenImage() {
        if (this.transferType == TransferType.FLOAT) {
            this.flattenImageToFloat();
        } else {
            this.flattenImageToInt();
        }
    }

    private void flattenImageToInt() {
        int numXTiles = this.image.getNumXTiles();
        int numYTiles = this.image.getNumYTiles();
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)3, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)1);
        TiledImage destImage = new TiledImage(0, 0, this.image.getWidth(), this.image.getHeight(), 0, 0, sm, (ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 3));
        for (int yt = 0; yt < numYTiles; ++yt) {
            for (int xt = 0; xt < numXTiles; ++xt) {
                Raster srcTile = this.image.getTile(xt, yt);
                WritableRaster destTile = destImage.getWritableTile(xt, yt);
                int[] data = new int[srcTile.getDataBuffer().getSize()];
                srcTile.getDataElements(srcTile.getMinX(), srcTile.getMinY(), srcTile.getWidth(), srcTile.getHeight(), data);
                Rectangle bounds = destTile.getBounds();
                destTile.setPixels(bounds.x, bounds.y, bounds.width, bounds.height, data);
                destImage.releaseWritableTile(xt, yt);
            }
        }
        this.image = destImage;
    }

    private void flattenImageToFloat() {
        int numXTiles = this.image.getNumXTiles();
        int numYTiles = this.image.getNumYTiles();
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)4, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)1);
        TiledImage destImage = new TiledImage(0, 0, this.image.getWidth(), this.image.getHeight(), 0, 0, sm, (ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 4));
        for (int yt = 0; yt < numYTiles; ++yt) {
            for (int xt = 0; xt < numXTiles; ++xt) {
                Raster srcTile = this.image.getTile(xt, yt);
                WritableRaster destTile = destImage.getWritableTile(xt, yt);
                int[] data = new int[srcTile.getDataBuffer().getSize()];
                srcTile.getDataElements(srcTile.getMinX(), srcTile.getMinY(), srcTile.getWidth(), srcTile.getHeight(), data);
                Rectangle bounds = destTile.getBounds();
                int k = 0;
                int dy = bounds.y;
                for (int drow = 0; drow < bounds.height; ++drow) {
                    int dx = bounds.x;
                    int dcol = 0;
                    while (dcol < bounds.width) {
                        destTile.setSample(dx, dy, 0, Float.intBitsToFloat(data[k]));
                        ++dx;
                        ++dcol;
                        ++k;
                    }
                    ++dy;
                }
                destImage.releaseWritableTile(xt, yt);
            }
        }
        this.image = destImage;
    }

    private void drawGeometry(Geometries geomType, Geometry geometry) {
        Coordinate[] coords = geometry.getCoordinates();
        if (coords.length > this.coordGridX.length) {
            int n = coords.length / 1000 + 1;
            this.coordGridX = new int[n * 1000];
            this.coordGridY = new int[n * 1000];
        }
        DirectPosition2D worldPos = new DirectPosition2D();
        try {
            for (int n = 0; n < coords.length; ++n) {
                worldPos.setLocation(coords[n].x, coords[n].y);
                GridCoordinates2D gridPos = this.gridGeom.worldToGrid((DirectPosition)worldPos);
                this.coordGridX[n] = gridPos.x;
                this.coordGridY[n] = gridPos.y;
            }
        }
        catch (TransformException ex) {
            throw new RuntimeException(ex);
        }
        switch (geomType) {
            case POLYGON: {
                this.graphics.fillPolygon(this.coordGridX, this.coordGridY, coords.length);
                break;
            }
            case LINESTRING: {
                this.graphics.drawPolyline(this.coordGridX, this.coordGridY, coords.length);
                break;
            }
            case POINT: {
                this.graphics.fillRect(this.coordGridX[0], this.coordGridY[0], 1, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid geometry type: " + geomType.getName());
            }
        }
    }

    private Color valueToColor(Number value) {
        int intBits = this.transferType == TransferType.FLOAT ? Float.floatToIntBits(value.floatValue()) : value.intValue();
        return new Color(intBits, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValueSource {
        PROPERTY_NAME,
        EXPRESSION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TransferType {
        INTEGRAL,
        FLOAT;

    }
}

