/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.test.TestData;

public abstract class RendererBaseTest {
    protected RendererBaseTest() {
    }

    protected static BufferedImage showRender(String testName, GTRenderer renderer, long timeOut, ReferencedEnvelope ... bounds) throws Exception {
        return RendererBaseTest.showRender(testName, renderer, timeOut, bounds, null);
    }

    protected static BufferedImage showRender(String testName, GTRenderer renderer, long timeOut, ReferencedEnvelope[] bounds, RenderListener listener) throws Exception {
        BufferedImage[] images = new BufferedImage[bounds.length];
        for (int i = 0; i < images.length; ++i) {
            images[i] = RendererBaseTest.renderImage(renderer, bounds[i], listener);
        }
        final BufferedImage image = RendererBaseTest.mergeImages(images);
        String headless = System.getProperty("java.awt.headless", "false");
        if (!headless.equalsIgnoreCase("true") && TestData.isInteractiveTest()) {
            try {
                Frame frame = new Frame(testName);
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        e.getWindow().dispose();
                    }
                });
                Panel p = new Panel(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
                    }

                    public void paint(Graphics g) {
                        g.drawImage(image, 0, 0, this);
                    }
                };
                frame.add(p);
                frame.pack();
                frame.setVisible(true);
                Thread.sleep(timeOut);
                frame.dispose();
            }
            catch (HeadlessException exception) {
                return image;
            }
        }
        boolean hasData = false;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (image.getRGB(x, y) == 0) continue;
                hasData = true;
            }
        }
        assert (hasData);
        return image;
    }

    public static BufferedImage renderImage(GTRenderer renderer, ReferencedEnvelope bounds, RenderListener listener) {
        int w = 300;
        int h = 300;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        RendererBaseTest.render(renderer, g, new Rectangle(w, h), bounds, listener);
        return image;
    }

    public static BufferedImage mergeImages(BufferedImage[] images) {
        int totalWidth = 0;
        int height = 0;
        for (BufferedImage bufferedImage : images) {
            totalWidth += bufferedImage.getWidth();
            height = Math.max(height, bufferedImage.getHeight());
        }
        BufferedImage joinedImage = new BufferedImage(totalWidth, height, 2);
        Graphics g = joinedImage.getGraphics();
        int x = 0;
        for (BufferedImage bufferedImage : images) {
            g.drawImage(bufferedImage, x, 0, null);
            x += bufferedImage.getWidth();
        }
        return joinedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void render(GTRenderer renderer, Graphics g, Rectangle rect, ReferencedEnvelope bounds, RenderListener rendererListener) {
        try {
            if (rendererListener != null) {
                renderer.addRenderListener(rendererListener);
            }
            if (bounds == null) {
                renderer.paint((Graphics2D)g, rect, new AffineTransform());
            } else {
                renderer.paint((Graphics2D)g, rect, bounds);
            }
        }
        finally {
            if (rendererListener != null) {
                renderer.removeRenderListener(rendererListener);
            }
        }
    }

    public static BufferedImage render(MapContext map) throws Exception {
        StreamingRenderer r = new StreamingRenderer();
        r.setContext(map);
        return RendererBaseTest.showRender("testPointLabeling", (GTRenderer)r, 5000L, map.getLayerBounds());
    }

    protected static Style loadStyle(Object loader, String sldFilename) throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)loader, (String)sldFilename);
        SLDParser stylereader = new SLDParser(factory, surl);
        Style style = stylereader.readXML()[0];
        return style;
    }
}

