/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape.shapehandler.simple;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.renderer.ScreenMap;
import org.geotools.renderer.shape.GeometryHandlerUtilities;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.geotools.renderer.shape.SimpleGeometry;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class PointHandler
implements ShapeHandler {
    private ShapeType type;
    private Envelope bbox;
    private MathTransform mt;
    private ScreenMap screenMap;
    Logger LOGGER = ShapefileRenderer.LOGGER;
    int skipped = 0;

    public PointHandler(ShapeType type, Envelope env, Rectangle screenSize, MathTransform mt, boolean hasOpacity) throws TransformException {
        if (mt == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.bbox = env;
        this.mt = mt;
        this.screenMap = GeometryHandlerUtilities.calculateScreenSize(screenSize, hasOpacity);
    }

    public ShapeType getShapeType() {
        return this.type;
    }

    public Object read(ByteBuffer buffer, ShapeType type, boolean flatFeature) {
        if (type == ShapeType.NULL) {
            this.LOGGER.finest("shape type is NULL");
            return null;
        }
        double[][] coords = new double[][]{{buffer.getDouble(), buffer.getDouble()}};
        Envelope geomBBox = new Envelope(coords[0][0], coords[0][0], coords[0][1], coords[0][1]);
        if (!this.bbox.intersects(geomBBox)) {
            this.LOGGER.finest("Point doesn't intersect with envelope");
            return null;
        }
        double[][] transformed = new double[][]{new double[2]};
        if (!this.mt.isIdentity()) {
            try {
                this.mt.transform(coords[0], 0, transformed[0], 0, 1);
            }
            catch (Exception e) {
                ShapefileRenderer.LOGGER.severe("could not transform coordinates" + e.getLocalizedMessage());
            }
        } else {
            transformed = coords;
        }
        if (this.screenMap.checkAndSet((int)transformed[0][0], (int)transformed[0][1])) {
            this.LOGGER.finest("Point already rendered" + transformed[0][0] + " " + transformed[0][1]);
            return null;
        }
        return this.createGeometry(type, geomBBox, transformed);
    }

    protected Object createGeometry(ShapeType type, Envelope geomBBox, double[][] transformed) {
        return new SimpleGeometry(type, transformed, geomBBox);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        throw new UnsupportedOperationException("This handler is only for reading");
    }

    public int getLength(Object geometry) {
        return 0;
    }
}

