/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiLineHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;
    double[] xy;
    double[] z;

    public MultiLineHandler(GeometryFactory gf) {
        this.shapeType = ShapeType.ARC;
        this.geometryFactory = gf;
    }

    public MultiLineHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.ARC && type != ShapeType.ARCM && type != ShapeType.ARCZ) {
            throw new ShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getLength(Object geometry) {
        int length;
        MultiLineString multi = (MultiLineString)geometry;
        int numlines = multi.getNumGeometries();
        int numpoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.ARC) {
            length = 44 + 4 * numlines + numpoints * 16;
        } else if (this.shapeType == ShapeType.ARCM) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints;
        } else if (this.shapeType == ShapeType.ARCZ) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints + 8 + 8 + 8 * numpoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.shapeType);
        }
        return length;
    }

    private Object createNull() {
        return this.geometryFactory.createMultiLineString(null);
    }

    public Object read(ByteBuffer buffer, ShapeType type, boolean flatGeometry) {
        int finish;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        int dimensions = this.shapeType == ShapeType.ARCZ && !flatGeometry ? 3 : 2;
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        int i = 0;
        while (i < numParts) {
            partOffsets[i] = buffer.getInt();
            ++i;
        }
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        int start = 0;
        int length = 0;
        boolean clonePoint = false;
        DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        int part = 0;
        while (part < numParts) {
            finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            length = finish - (start = partOffsets[part]);
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }
            CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(length, dimensions);
            double[] xy = new double[length * 2];
            doubleBuffer.get(xy);
            int i2 = 0;
            while (i2 < length) {
                cs.setOrdinate(i2, 0, xy[i2 * 2]);
                cs.setOrdinate(i2, 1, xy[i2 * 2 + 1]);
                ++i2;
            }
            if (clonePoint) {
                cs.setOrdinate(1, 0, cs.getOrdinate(0, 0));
                cs.setOrdinate(1, 1, cs.getOrdinate(0, 1));
            }
            lines[part] = cs;
            ++part;
        }
        if (dimensions == 3) {
            doubleBuffer.position(doubleBuffer.position() + 2);
            part = 0;
            while (part < numParts) {
                finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - (start = partOffsets[part]);
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }
                double[] z = new double[length];
                doubleBuffer.get(z);
                int i3 = 0;
                while (i3 < length) {
                    lines[part].setOrdinate(i3, 2, z[i3]);
                    ++i3;
                }
                ++part;
            }
        }
        LineString[] lineStrings = new LineString[numParts];
        int part2 = 0;
        while (part2 < numParts) {
            lineStrings[part2] = this.geometryFactory.createLineString(lines[part2]);
            ++part2;
        }
        return this.geometryFactory.createMultiLineString(lineStrings);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        int ncoords;
        MultiLineString multi = (MultiLineString)geometry;
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int numParts = multi.getNumGeometries();
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        int npoints = multi.getNumPoints();
        buffer.putInt(numParts);
        buffer.putInt(npoints);
        int idx = 0;
        int i = 0;
        while (i < numParts) {
            lines[i] = ((LineString)multi.getGeometryN(i)).getCoordinateSequence();
            buffer.putInt(idx);
            idx += lines[i].size();
            ++i;
        }
        int lineN = 0;
        while (lineN < lines.length) {
            CoordinateSequence coords = lines[lineN];
            if (this.shapeType == ShapeType.ARCZ) {
                JTSUtilities.zMinMax(coords, zExtreame);
            }
            ncoords = coords.size();
            int t = 0;
            while (t < ncoords) {
                buffer.putDouble(coords.getX(t));
                buffer.putDouble(coords.getY(t));
                ++t;
            }
            ++lineN;
        }
        if (this.shapeType == ShapeType.ARCZ) {
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            lineN = 0;
            while (lineN < lines.length) {
                CoordinateSequence coords = lines[lineN];
                ncoords = coords.size();
                int t = 0;
                while (t < ncoords) {
                    double z = coords.getOrdinate(t, 2);
                    if (Double.isNaN(z)) {
                        buffer.putDouble(0.0);
                    } else {
                        buffer.putDouble(z);
                    }
                    ++t;
                }
                ++lineN;
            }
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            int t = 0;
            while (t < npoints) {
                buffer.putDouble(-1.0E41);
                ++t;
            }
        }
    }
}

