/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.index.quadtree.StoreException;

public class Node {
    protected int numShapesId;
    private boolean visited = false;
    private boolean childrenVisited = false;
    private Envelope bounds;
    protected int[] shapesId;
    protected List subNodes;

    public Node(Envelope bounds) {
        this.bounds = new Envelope(bounds);
        this.subNodes = new ArrayList(4);
        this.shapesId = null;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public void setBounds(Envelope bounds) {
        this.bounds = bounds;
    }

    public int getNumSubNodes() {
        return this.subNodes.size();
    }

    public int getNumShapeIds() {
        return this.numShapesId;
    }

    public void addSubNode(Node node) {
        if (node == null) {
            throw new NullPointerException("Cannot add null to subnodes");
        }
        this.subNodes.add(node);
    }

    public boolean removeSubNode(Node node) {
        return this.subNodes.remove(node);
    }

    public void clearSubNodes() {
        this.subNodes.clear();
    }

    public Node getSubNode(int pos) throws StoreException {
        return (Node)this.subNodes.get(pos);
    }

    public void addShapeId(int id) {
        if (this.shapesId == null) {
            this.shapesId = new int[4];
            Arrays.fill(this.shapesId, -1);
        } else if (this.shapesId.length == this.numShapesId) {
            int[] newIds = new int[(int)Math.ceil((double)this.numShapesId * 3.0 / 2.0)];
            Arrays.fill(newIds, -1);
            System.arraycopy(this.shapesId, 0, newIds, 0, this.numShapesId);
            this.shapesId = newIds;
        }
        this.shapesId[this.numShapesId] = id;
        ++this.numShapesId;
    }

    public int getShapeId(int pos) {
        if (pos >= this.numShapesId) {
            throw new ArrayIndexOutOfBoundsException("Requsted " + pos + " but size = " + this.numShapesId);
        }
        return this.shapesId[pos];
    }

    public void setShapesId(int[] ids) {
        if (ids == null) {
            this.numShapesId = 0;
        } else {
            this.shapesId = ids;
            this.numShapesId = 0;
            int i = 0;
            while (i < ids.length) {
                if (ids[i] == -1) break;
                ++this.numShapesId;
                ++i;
            }
        }
    }

    public void setShapesId(Node other) {
        this.numShapesId = other.numShapesId;
        this.shapesId = other.shapesId;
    }

    public int[] getShapesId() {
        return this.shapesId;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public boolean isChildrenVisited() {
        return this.childrenVisited;
    }

    public void setChildrenVisited(boolean childrenVisited) {
        this.childrenVisited = childrenVisited;
    }

    public Node copy() throws IOException {
        Node copy = new Node(this.bounds);
        copy.setShapesId(this.shapesId);
        copy.numShapesId = this.numShapesId;
        return copy;
    }

    public void close() {
    }

    public void clean() {
        this.shapesId = null;
        this.numShapesId = 0;
        this.subNodes.clear();
    }

    public void pack() {
        if (this.numShapesId == 0) {
            this.shapesId = null;
        } else if (this.shapesId != null && this.shapesId.length > this.numShapesId) {
            int[] ids = new int[this.numShapesId];
            System.arraycopy(this.shapesId, 0, ids, 0, this.numShapesId);
            this.shapesId = ids;
        }
    }
}

