/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.swing.JMapPane;
import org.geotools.swing.event.MapMouseAdapter;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.event.MapPaneAdapter;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.menu.CRSPopupMenu;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class StatusBar
extends JPanel {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    private JMapPane mapPane;
    private MapContext context;
    private MapMouseListener mouseListener;
    private MapPaneAdapter mapPaneListener;
    private JLabel renderLabel;
    private JLabel coordsLabel;
    private JLabel boundsLabel;
    private JButton crsBtn;
    private CRSPopupMenu crsMenu;
    private ImageIcon busyIcon;
    private static final String BUSY_ICON_IMAGE = "/org/geotools/swing/icons/busy_16.gif";

    public StatusBar() {
        this((JMapPane)null);
    }

    public StatusBar(JMapPane pane) {
        this.createListeners();
        this.initComponents();
        if (pane != null) {
            this.setMapPane(pane);
        }
    }

    public void setMapPane(JMapPane newPane) {
        if (newPane == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        if (this.mapPane != newPane) {
            if (this.mapPane != null) {
                this.mapPane.removeMouseListener(this.mouseListener);
            }
            newPane.addMouseListener(this.mouseListener);
            newPane.addMapPaneListener(this.mapPaneListener);
            this.context = newPane.getMapContext();
            this.mapPane = newPane;
            this.crsMenu.setMapPane(this.mapPane);
        }
    }

    public void clearCoords() {
        this.coordsLabel.setText("");
    }

    public void clearBounds() {
        this.boundsLabel.setText("");
    }

    public void displayCoords(DirectPosition2D mapPos) {
        if (mapPos != null) {
            this.coordsLabel.setText(String.format("  %.2f %.2f", mapPos.x, mapPos.y));
        }
    }

    public void displayBounds(Envelope bounds) {
        if (bounds != null) {
            this.boundsLabel.setText(String.format("Min:%.2f %.2f Span:%.2f %.2f", bounds.getMinimum(0), bounds.getMinimum(1), bounds.getSpan(0), bounds.getSpan(1)));
        }
    }

    public void displayCRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            this.crsBtn.setText(stringRes.getString("crs_undefined"));
        } else {
            this.crsBtn.setText(crs.getName().toString());
        }
    }

    private void initComponents() {
        MigLayout lm = new MigLayout("insets 0");
        this.setLayout((LayoutManager)lm);
        Font font = Font.decode("Courier-12");
        this.busyIcon = new ImageIcon(StatusBar.class.getResource(BUSY_ICON_IMAGE));
        this.renderLabel = new JLabel();
        this.renderLabel.setHorizontalTextPosition(10);
        Rectangle2D rect = this.getFontMetrics(font).getStringBounds("rendering", this.renderLabel.getGraphics());
        String constraint = String.format("gapx 5, width %d!, height %d!", (int)rect.getWidth() + this.busyIcon.getIconWidth() + this.renderLabel.getIconTextGap(), (int)Math.max(rect.getHeight(), (double)this.busyIcon.getIconHeight()) + 6);
        this.add((Component)this.renderLabel, constraint);
        this.coordsLabel = new JLabel();
        Graphics graphics = this.coordsLabel.getGraphics();
        this.coordsLabel.setFont(font);
        rect = this.getFontMetrics(font).getStringBounds("  00000000.000 00000000.000", graphics);
        constraint = String.format("width %d!, height %d!", (int)rect.getWidth() + 10, (int)rect.getHeight() + 6);
        this.add((Component)this.coordsLabel, constraint);
        this.boundsLabel = new JLabel();
        this.boundsLabel.setFont(font);
        rect = this.getFontMetrics(font).getStringBounds("Min: 00000000.000 00000000.000 Span: 00000000.000 00000000.000", graphics);
        constraint = String.format("width %d!, height %d!", (int)rect.getWidth() + 10, (int)rect.getHeight() + 6);
        this.add((Component)this.boundsLabel, constraint);
        this.crsBtn = new JButton(stringRes.getString("crs_undefined"));
        this.crsBtn.setFont(font);
        rect = this.getFontMetrics(font).getStringBounds("X", graphics);
        constraint = String.format("height %d!", (int)rect.getHeight() + 6);
        this.crsBtn.setToolTipText(stringRes.getString("tool_tip_statusbar_crs"));
        this.crsMenu = new CRSPopupMenu();
        this.crsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusBar.this.crsMenu.show(StatusBar.this.crsBtn, 0, 0);
            }
        });
        this.add((Component)this.crsBtn, constraint);
    }

    private void createListeners() {
        this.mouseListener = new MapMouseAdapter(){

            public void onMouseMoved(MapMouseEvent ev) {
                StatusBar.this.displayCoords(ev.getMapPosition());
            }

            public void onMouseExited(MapMouseEvent ev) {
                StatusBar.this.clearCoords();
            }
        };
        this.mapPaneListener = new MapPaneAdapter(){

            public void onDisplayAreaChanged(MapPaneEvent ev) {
                ReferencedEnvelope env = StatusBar.this.mapPane.getDisplayArea();
                if (env != null) {
                    StatusBar.this.displayBounds((Envelope)env);
                    StatusBar.this.displayCRS(env.getCoordinateReferenceSystem());
                }
            }

            public void onResized(MapPaneEvent ev) {
                ReferencedEnvelope env = StatusBar.this.mapPane.getDisplayArea();
                if (env != null) {
                    StatusBar.this.displayBounds((Envelope)env);
                    StatusBar.this.displayCRS(env.getCoordinateReferenceSystem());
                }
            }

            public void onRenderingStarted(MapPaneEvent ev) {
                StatusBar.this.renderLabel.setText("rendering");
                StatusBar.this.renderLabel.setIcon(StatusBar.this.busyIcon);
            }

            public void onRenderingStopped(MapPaneEvent ev) {
                StatusBar.this.renderLabel.setText("");
                StatusBar.this.renderLabel.setIcon(null);
            }

            public void onRenderingProgress(MapPaneEvent ev) {
                float progress = ((Number)ev.getData()).floatValue();
                System.out.println("render progress: " + progress);
            }
        };
    }
}

