/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.swing.tool.InfoToolHelper;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorLayerHelper
extends InfoToolHelper<FeatureCollection> {
    private static final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    private static final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
    private final WeakReference<MapLayer> layerRef;
    private final String attrName;
    private final boolean isPolygonGeometry;

    public VectorLayerHelper(MapContext context, MapLayer layer) {
        super(context, layer.getFeatureSource().getSchema().getCoordinateReferenceSystem());
        this.layerRef = new WeakReference<MapLayer>(layer);
        GeometryDescriptor geomDesc = layer.getFeatureSource().getSchema().getGeometryDescriptor();
        this.attrName = geomDesc.getLocalName();
        Class geomClass = geomDesc.getType().getBinding();
        Geometries type = Geometries.getForBinding((Class)geomClass);
        this.isPolygonGeometry = type == Geometries.POLYGON || type == Geometries.MULTIPOLYGON;
    }

    @Override
    public boolean isValid() {
        return this.getMapContext() != null && this.layerRef != null && this.layerRef.get() != null;
    }

    public MapLayer getMapLayer() {
        return this.layerRef != null ? (MapLayer)this.layerRef.get() : null;
    }

    @Override
    public FeatureCollection getInfo(DirectPosition2D pos, Object ... params) throws IOException {
        FeatureCollection collection = null;
        MapLayer layer = (MapLayer)this.layerRef.get();
        if (layer != null) {
            Intersects filter = null;
            if (this.isPolygonGeometry) {
                Geometry posGeom = this.createSearchPos(pos);
                filter = filterFactory.intersects((Expression)filterFactory.property(this.attrName), (Expression)filterFactory.literal((Object)posGeom));
            } else {
                double radius = ((Number)params[0]).doubleValue();
                ReferencedEnvelope env = this.createSearchEnv(pos, radius);
                filter = filterFactory.bbox((Expression)filterFactory.property(this.attrName), (BoundingBox)env);
            }
            DefaultQuery query = new DefaultQuery(null, (Filter)filter);
            query.setCoordinateSystemReproject(this.getMapContext().getCoordinateReferenceSystem());
            collection = layer.getFeatureSource().getFeatures((Query)query);
        }
        return collection;
    }

    private Geometry createSearchPos(DirectPosition2D pos) {
        MathTransform transform;
        Point point = geometryFactory.createPoint(new Coordinate(pos.x, pos.y));
        if (this.isTransformRequired() && (transform = this.getTransform()) != null) {
            try {
                point = JTS.transform((Geometry)point, (MathTransform)transform);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return point;
    }

    private ReferencedEnvelope createSearchEnv(DirectPosition2D pos, double radius) {
        CoordinateReferenceSystem contextCRS = this.getMapContext().getCoordinateReferenceSystem();
        ReferencedEnvelope env = new ReferencedEnvelope(pos.x - radius, pos.x + radius, pos.y - radius, pos.y + radius, contextCRS);
        if (this.isTransformRequired()) {
            CoordinateReferenceSystem layerCRS = ((MapLayer)this.layerRef.get()).getFeatureSource().getSchema().getCoordinateReferenceSystem();
            try {
                env = env.transform(layerCRS, true);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return env;
    }
}

