/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: TerralibCachingDataStoreFactory.java
 * created: Dec 17, 2009
 */
package org.tecgraf.tdk.data;

import static org.tecgraf.tdk.data.DBConnectionTerralibCachingUtils.CACHING_TE_TYPE;
import static org.tecgraf.tdk.data.DBConnectionTerralibCachingUtils.TERRALIB_CACHED_DATABASE_TYPE;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

import org.geotools.data.DataStore;
import org.geotools.data.terralib.TerralibDataStoreFactory;
import org.geotools.data.terralib.connection.DBConnectionParamUtils;

/**
 * Implements the DataStoreFactory for terralib datastore with cache 
 * @author fabiomano
 */
public class TerralibCachingDataStoreFactory extends AbstractDataStoreFactoryDecorator
{
    public TerralibCachingDataStoreFactory()
    {
        super(new TerralibDataStoreFactory());
    }

    /* (non-Javadoc)
     * @see org.tecgraf.tdk.data.AbstractDataStoreFactoryDecorator#createTargetDataStore(java.util.Map)
     */
    @Override
    public DataStore createTargetDataStore(Map<String, Serializable> params) throws IOException
    {
        if (params == null)
            throw new IllegalArgumentException("params can't be null");
        
        TerralibDataStoreFactory factory = new TerralibDataStoreFactory();
        params.put(DBConnectionParamUtils.DBTYPE.key, DBConnectionParamUtils.TERRALIB_DATABASE_TYPE);
        DataStore ds = factory.createDataStore(params);
        params.remove(DBConnectionParamUtils.DBTYPE.key);
        return ds;
    }

    /* (non-Javadoc)
     * @see org.tecgraf.tdk.data.AbstractDataStoreFactoryDecorator#canProcess(java.util.Map)
     */
    @Override
    public boolean canProcess(Map<String, Serializable> params)
    {
        
        if (params == null)
            throw new IllegalArgumentException("params should not be null.");
        
        String cachedDbType = (String) params.get(CACHING_TE_TYPE.key);
        if ((cachedDbType == null) || (!cachedDbType.equals(TERRALIB_CACHED_DATABASE_TYPE)))
            return false;
        
        params.put(DBConnectionParamUtils.DBTYPE.key, DBConnectionParamUtils.TERRALIB_DATABASE_TYPE);
        boolean canProcess =super.canProcess(params);
        params.remove(DBConnectionParamUtils.DBTYPE.key);
        return canProcess;
    }
    
    /* (non-Javadoc)
     * @see org.tecgraf.tdk.data.AbstractDataStoreFactoryDecorator#getParametersInfo()
     */
    @Override
    public Param[] getParametersInfo()
    {
        Param[] params = super.getParametersInfo();
        
        for(int i = 0 ; i < params.length ; i ++)
        {
        	if(DBConnectionParamUtils.DBTYPE.equals(params[i]))
        	{
        		params[i] = CACHING_TE_TYPE;
        	}
        }
        return params;
    }
}
