/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import java.io.Reader;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.h2.jdbc.JdbcClob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2ClobConverterFactory
implements ConverterFactory {
    H2ClobConverter converter = new H2ClobConverter();

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (!String.class.equals(target)) {
            return null;
        }
        if (!JdbcClob.class.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class H2ClobConverter
    implements Converter {
        H2ClobConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T convert(Object source, Class<T> target) throws Exception {
            JdbcClob clob = (JdbcClob)source;
            Reader r = null;
            try {
                int read;
                StringBuilder sb = new StringBuilder();
                char[] cbuf = new char[4096];
                r = clob.getCharacterStream();
                while ((read = r.read(cbuf)) > 0) {
                    sb.append(cbuf, 0, read);
                }
                String string = sb.toString();
                return (T)string;
            }
            finally {
                r.close();
            }
        }
    }
}

