/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.geotools.data.h2.H2Dialect;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class H2FilterToSQL
extends FilterToSQL {
    static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat DATETIME_FORMAT;

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = super.createFilterCapabilities();
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        return caps;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry g = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (g instanceof LinearRing) {
            g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
        }
        this.out.write("ST_GeomFromText('" + g.toText() + "', " + this.currentSRID + ")");
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            String spatialIndex;
            if (filter instanceof DistanceBufferOperator) {
                this.out.write("ST_Distance(");
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(", ");
                geometry.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator");
                }
                this.out.write(Double.toString(((DistanceBufferOperator)filter).getDistance()));
            } else if (filter instanceof BBOX) {
                this.out.write("ST_Intersects(");
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(",");
                geometry.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
            } else {
                if (filter instanceof Contains) {
                    this.out.write("ST_Contains(");
                } else if (filter instanceof Crosses) {
                    this.out.write("ST_Crosses(");
                } else if (filter instanceof Disjoint) {
                    this.out.write("ST_Disjoint(");
                } else if (filter instanceof Equals) {
                    this.out.write("ST_Equals(");
                } else if (filter instanceof Intersects) {
                    this.out.write("ST_Intersects(");
                } else if (filter instanceof Overlaps) {
                    this.out.write("ST_Overlaps(");
                } else if (filter instanceof Touches) {
                    this.out.write("ST_Touches(");
                } else if (filter instanceof Within) {
                    this.out.write("ST_Within(");
                } else {
                    throw new RuntimeException("Unknown operator: " + filter);
                }
                if (swapped) {
                    geometry.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    property.accept((ExpressionVisitor)this, extraData);
                } else {
                    property.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    geometry.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(")");
            }
            if (!(filter instanceof Disjoint) && (spatialIndex = (String)this.currentGeometry.getUserData().get(H2Dialect.H2_SPATIAL_INDEX)) != null && this.primaryKey.getColumns().size() == 1 && Number.class.isAssignableFrom(((PrimaryKeyColumn)this.primaryKey.getColumns().get(0)).getType())) {
                Envelope e = (Envelope)geometry.evaluate(null, Envelope.class);
                this.out.write(" AND ");
                this.out.write("\"" + ((PrimaryKeyColumn)this.primaryKey.getColumns().get(0)).getName() + "\" ");
                this.out.write("IN (");
                this.out.write("SELECT CAST(HATBOX_JOIN_ID AS INT)");
                this.out.write(" FROM HATBOX_MBR_INTERSECTS_ENV(");
                if (this.databaseSchema != null) {
                    this.out.write("'" + this.databaseSchema + "', ");
                } else {
                    this.out.write("'PUBLIC', ");
                }
                this.out.write("'" + this.featureType.getTypeName() + "', ");
                this.out.write(e.getMinX() + ", " + e.getMaxX() + ", " + e.getMinY() + ", " + e.getMaxY());
                this.out.write(")");
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    protected void writeLiteral(Object literal) throws IOException {
        if (literal instanceof java.util.Date) {
            this.out.write("PARSEDATETIME(");
            if (literal instanceof Date) {
                this.out.write("'" + DATE_FORMAT.format(literal) + "', 'yyyy-MM-dd'");
            } else {
                this.out.write("'" + DATETIME_FORMAT.format(literal) + "', 'yyyy-MM-dd HH:mm:ss.SSSZ'");
            }
            this.out.write(")");
        } else {
            super.writeLiteral(literal);
        }
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    }
}

