/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.h2.H2DialectPrepared;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class H2DataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"h2");
    public static final DataAccessFactory.Param ASSOCIATIONS = new DataAccessFactory.Param("Associations", Boolean.class, "Associations", false, (Object)Boolean.FALSE);
    File baseDirectory = null;

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.remove(H2DataStoreFactory.HOST.key);
        parameters.remove(H2DataStoreFactory.PORT.key);
        parameters.remove(H2DataStoreFactory.SCHEMA.key);
        parameters.remove(H2DataStoreFactory.USER.key);
        parameters.remove(H2DataStoreFactory.PASSWD.key);
        parameters.put(H2DataStoreFactory.ASSOCIATIONS.key, ASSOCIATIONS);
        parameters.put(H2DataStoreFactory.DBTYPE.key, DBTYPE);
    }

    public String getDisplayName() {
        return "H2";
    }

    public String getDescription() {
        return "H2 Embedded Database";
    }

    protected String getDatabaseID() {
        return (String)H2DataStoreFactory.DBTYPE.sample;
    }

    protected String getDriverClassName() {
        return "org.h2.Driver";
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new H2DialectPrepared(dataStore);
    }

    protected DataSource createDataSource(Map params, SQLDialect dialect) throws IOException {
        String database = (String)DATABASE.lookUp(params);
        BasicDataSource dataSource = new BasicDataSource();
        if (this.baseDirectory == null) {
            dataSource.setUrl("jdbc:h2:" + database);
        } else {
            String location = new File(this.baseDirectory, database).getAbsolutePath();
            dataSource.setUrl("jdbc:h2:file:" + location);
        }
        dataSource.setDriverClassName("org.h2.Driver");
        dataSource.setPoolPreparedStatements(false);
        return dataSource;
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        Boolean foreignKeys = (Boolean)ASSOCIATIONS.lookUp(params);
        if (foreignKeys != null) {
            dataStore.setAssociations(foreignKeys.booleanValue());
        }
        return dataStore;
    }

    protected String getValidationQuery() {
        return null;
    }
}

