/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2Dialect
extends SQLDialect {
    public H2Dialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public String getNameEscape() {
        return "\"";
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        super.registerSqlTypeToClassMappings(mappings);
        mappings.put(new Integer(2004), Geometry.class);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, new Integer(2004));
        mappings.put(Point.class, new Integer(2004));
        mappings.put(LineString.class, new Integer(2004));
        mappings.put(Polygon.class, new Integer(2004));
        mappings.put(GeometryCollection.class, new Integer(2004));
        mappings.put(MultiPoint.class, new Integer(2004));
        mappings.put(MultiLineString.class, new Integer(2004));
        mappings.put(MultiPolygon.class, new Integer(2004));
    }

    public void initializeConnection(Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            st.execute("SELECT GeoToolsVersion()");
            return;
        }
        catch (SQLException e) {
            BufferedReader r = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("h2.sql")));
            String line = null;
            while ((line = r.readLine()) != null) {
                st.execute(line);
            }
            r.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        String remark = columnMetaData.getString("REMARKS");
        if (remark != null) {
            if ("POINT".equalsIgnoreCase(remark)) {
                return Point.class;
            }
            if ("LINESTRING".equalsIgnoreCase(remark)) {
                return LineString.class;
            }
            if ("POLYGON".equalsIgnoreCase(remark)) {
                return Polygon.class;
            }
            if ("MULTIPOINT".equalsIgnoreCase(remark)) {
                return MultiPoint.class;
            }
            if ("MULTILINESTRING".equalsIgnoreCase(remark)) {
                return MultiLineString.class;
            }
            if ("MULTIPOLYGON".equalsIgnoreCase(remark)) {
                return MultiPolygon.class;
            }
        }
        return null;
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        Class binding;
        if (att instanceof GeometryDescriptor && this.isConcreteGeometry(binding = att.getType().getBinding())) {
            sql.append(" COMMENT '").append(binding.getSimpleName().toUpperCase()).append("'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            for (PropertyDescriptor ad : featureType.getDescriptors()) {
                Class binding;
                if (!(ad instanceof GeometryDescriptor) || !this.isConcreteGeometry(binding = ad.getType().getBinding())) continue;
                String tableName = featureType.getTypeName();
                String propertyName = ad.getName().getLocalPart();
                StringBuffer sql = new StringBuffer();
                sql.append("ALTER TABLE ");
                this.encodeTableName(tableName, sql);
                sql.append(" ADD CONSTRAINT ");
                this.encodeTableName(tableName + "_" + propertyName + "GeometryType", sql);
                sql.append(" CHECK ");
                this.encodeColumnName(propertyName, sql);
                sql.append(" IS NULL OR");
                sql.append(" GeometryType(");
                this.encodeColumnName(propertyName, sql);
                sql.append(") = '").append(binding.getSimpleName().toUpperCase()).append("'");
                LOGGER.fine(sql.toString());
                st.execute(sql.toString());
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    boolean isConcreteGeometry(Class binding) {
        return Point.class.isAssignableFrom(binding) || LineString.class.isAssignableFrom(binding) || Polygon.class.isAssignableFrom(binding) || MultiPoint.class.isAssignableFrom(binding) || MultiLineString.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT getSRID(");
        this.encodeColumnName(columnName, sql);
        sql.append(") ");
        sql.append("FROM ");
        if (schemaName != null) {
            this.encodeTableName(schemaName, sql);
            sql.append(".");
        }
        this.encodeSchemaName(tableName, sql);
        sql.append(" WHERE ");
        this.encodeColumnName(columnName, sql);
        sql.append(" is not null LIMIT 1");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            ResultSet rs;
            block9: {
                Integer n;
                rs = st.executeQuery(sql.toString());
                try {
                    if (!rs.next()) break block9;
                    n = new Integer(rs.getInt(1));
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                return n;
            }
            Integer n = null;
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("envelope(");
        this.encodeColumnName(geometryColumn, sql);
        sql.append(")");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return (Envelope)rs.getObject(column);
    }

    public void encodeGeometryValue(Geometry value, int srid, StringBuffer sql) throws IOException {
        sql.append("GeomFromText ('");
        sql.append(new WKTWriter().write(value));
        sql.append("',");
        sql.append(srid);
        sql.append(")");
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(column, sql);
        sql.append(" int AUTO_INCREMENT(1) PRIMARY KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sequenceName = tableName + "_" + columnName + "_SEQUENCE";
        sequenceName = sequenceName.toUpperCase();
        Statement st = cx.createStatement();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ");
            sql.append("WHERE SEQUENCE_NAME = '").append(sequenceName).append("'");
            this.dataStore.getLogger().fine(sql.toString());
            ResultSet rs = st.executeQuery(sql.toString());
            try {
                if (rs.next()) {
                    String string = sequenceName;
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            Integer n;
            String sql = "SELECT NEXTVAL('" + sequenceName + "')";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                rs.next();
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            Integer n;
            ResultSet rs = st.executeQuery("SELECT b.COLUMN_DEFAULT  FROM INFORMATION_SCHEMA.INDEXES A, INFORMATION_SCHEMA.COLUMNS B WHERE a.TABLE_NAME = b.TABLE_NAME  AND a.COLUMN_NAME = b.COLUMN_NAME  AND a.TABLE_NAME = '" + tableName + "' " + " AND a.COLUMN_NAME = '" + columnName + "' " + " AND a.PRIMARY_KEY = TRUE");
            String sequence = null;
            try {
                rs.next();
                String string = rs.getString(1);
                sequence = string.substring(string.indexOf("SYSTEM_SEQUENCE"), string.length() - 1);
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
            try {
                rs = schemaName != null ? st.executeQuery("SELECT CURRVAL('" + schemaName + "','" + sequence + "')") : st.executeQuery("SELECT CURRVAL('" + sequence + "')");
                rs.next();
                int value = rs.getInt(1);
                n = new Integer(value + 1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit > 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" LIMIT 2147483647");
            sql.append(" OFFSET " + offset);
        }
    }
}

