/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.OutStream;
import com.vividsolutions.jts.io.OutputStreamOutStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JTS {
    public static String GeoToolsVersion() {
        return "2.6-SNAPSHOT";
    }

    public static String AsWKT(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        return JTS.fromWKB(wkb).toText();
    }

    public static String EnvelopeAsText(byte[] wkb) {
        Envelope e = JTS.Envelope(wkb);
        if (e != null) {
            return e.toString();
        }
        return null;
    }

    public static byte[] GeomFromText(String wkt, int srid) {
        if (wkt == null) {
            return null;
        }
        WKTReader reader = new WKTReader();
        try {
            Geometry g = reader.read(wkt);
            g.setSRID(srid);
            return JTS.toWKB(g);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] GeomFromWKB(byte[] wkb) {
        return wkb;
    }

    public static int GetSRID(byte[] wkb) {
        if (wkb == null) {
            return -1;
        }
        return JTS.fromWKB(wkb).getSRID();
    }

    public static Envelope Envelope(byte[] wkb) {
        if (wkb == null) {
            Envelope e = new Envelope();
            e.setToNull();
            return e;
        }
        return JTS.fromWKB(wkb).getEnvelopeInternal();
    }

    public static String GeometryType(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = JTS.fromWKB(wkb);
        return g != null ? g.getGeometryType().toUpperCase() : null;
    }

    private static Geometry fromWKB(byte[] wkb) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(wkb, 0, wkb.length - 4);
            Geometry g = new WKBReader().read((InStream)new InputStreamInStream((InputStream)bytes));
            int srid = 0;
            srid |= wkb[wkb.length - 4] & 0xFF;
            srid <<= 8;
            srid |= wkb[wkb.length - 3] & 0xFF;
            srid <<= 8;
            srid |= wkb[wkb.length - 2] & 0xFF;
            srid <<= 8;
            g.setSRID(srid |= wkb[wkb.length - 1] & 0xFF);
            return g;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toWKB(Geometry g) {
        try {
            WKBWriter w = new WKBWriter();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            w.write(g, (OutStream)new OutputStreamOutStream((OutputStream)bytes));
            int srid = g.getSRID();
            bytes.write((byte)(srid >>> 24));
            bytes.write((byte)(srid >> 16 & 0xFF));
            bytes.write((byte)(srid >> 8 & 0xFF));
            bytes.write((byte)(srid & 0xFF));
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

