/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.sqlserver.SQLServerDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class SQLServerDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"sqlserver");
    public static final DataAccessFactory.Param INTSEC = new DataAccessFactory.Param("Integrated Security", Boolean.class, "Login as current windows user account. Works only in windows. Ignores user and password settings.", true, (Object)new Boolean(false));

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new SQLServerDialect(dataStore);
    }

    protected String getDatabaseID() {
        return (String)SQLServerDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "Microsoft SQL Server";
    }

    protected String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    protected String getValidationQuery() {
        return null;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(SQLServerDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(SQLServerDataStoreFactory.INTSEC.key, INTSEC);
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String url = super.getJDBCUrl(params);
        String db = (String)DATABASE.lookUp(params);
        Boolean intsec = (Boolean)INTSEC.lookUp(params);
        if (db != null) {
            url = String.valueOf(url.substring(0, url.lastIndexOf("/"))) + (db != null ? ";DatabaseName=" + db : "");
        }
        if (intsec.booleanValue()) {
            url = String.valueOf(url) + ";integratedSecurity=true";
        }
        return url;
    }
}

