/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

abstract class CallArithmeticRootNode
extends PRootNode {
    @Node.Child
    private ExecutionContext.CalleeContext calleeContext;

    protected CallArithmeticRootNode(TruffleLanguage<?> language) {
        super(language);
    }

    public boolean isInternal() {
        return true;
    }

    @Override
    public boolean isPythonInternal() {
        return true;
    }

    public Object execute(VirtualFrame frame) {
        if (this.calleeContext == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.calleeContext = (ExecutionContext.CalleeContext)this.insert(ExecutionContext.CalleeContext.create());
        }
        this.calleeContext.enter(frame);
        try {
            Object object = this.doCall(frame);
            return object;
        }
        finally {
            this.calleeContext.exit(frame, this);
        }
    }

    protected abstract Object doCall(VirtualFrame var1);

    @Override
    public boolean setsUpCalleeContext() {
        return true;
    }
}

