/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfilesFactory;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class BuiltinClassProfiles {
    private BuiltinClassProfiles() {
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class IsBuiltinObjectProfile
    extends Node {
        public static boolean profileObjectUncached(Object obj, PythonBuiltinClassType type) {
            return IsBuiltinObjectProfile.getUncached().profileObject(null, obj, type);
        }

        public static IsBuiltinObjectProfile getUncached() {
            return BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.getUncached();
        }

        @NeverDefault
        public static IsBuiltinObjectProfile create() {
            return BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.create();
        }

        public final boolean profileException(Node inliningTarget, PException obj, PythonBuiltinClassType type) {
            return this.profileObject(inliningTarget, obj.getUnreifiedException(), type);
        }

        public final boolean profileObject(Node inliningTarget, Object obj, PythonBuiltinClassType type) {
            return this.execute(inliningTarget, obj, type);
        }

        public final boolean profileObjectCached(Object obj, PythonBuiltinClassType type) {
            return this.execute(this, obj, type);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization
        static boolean doIt(Node inliningTarget, Object obj, PythonBuiltinClassType type, @Cached GetClassNode getClassNode, @Cached IsBuiltinClassProfile isBuiltinClassProfile) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            return isBuiltinClassProfile.execute(inliningTarget, clazz, type);
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsOtherBuiltinObjectProfile
    extends Node {
        public final boolean profileIsOtherBuiltinObject(Node inliningTarget, Object obj, PythonBuiltinClassType forbiddenType) {
            return this.execute(inliningTarget, obj, forbiddenType);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization
        static boolean doIt(Node inliningTarget, Object obj, PythonBuiltinClassType forbiddenType, @Cached GetClassNode getClassNode, @Cached IsOtherBuiltinClassProfile isOtherBuiltinClass) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            return isOtherBuiltinClass.execute(inliningTarget, clazz, forbiddenType);
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class IsBuiltinObjectExactProfile
    extends Node {
        public static boolean profileObjectUncached(Object obj, PythonBuiltinClassType type) {
            return IsBuiltinObjectExactProfile.getUncached().profileObject(null, obj, type);
        }

        public static boolean profileExceptionUncached(PException obj, PythonBuiltinClassType type) {
            return BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.getUncached().profileException(null, obj, type);
        }

        public static IsBuiltinObjectExactProfile getUncached() {
            return BuiltinClassProfilesFactory.IsBuiltinObjectExactProfileNodeGen.getUncached();
        }

        @NeverDefault
        public static IsBuiltinObjectExactProfile create() {
            return BuiltinClassProfilesFactory.IsBuiltinObjectExactProfileNodeGen.create();
        }

        public final boolean profileObject(Node inliningTarget, Object obj, PythonBuiltinClassType type) {
            return this.execute(inliningTarget, obj, type);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization
        static boolean doIt(Node inliningTarget, Object obj, PythonBuiltinClassType type, @Cached GetClassNode getClassNode, @Cached IsBuiltinClassExactProfile isBuiltinClass) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            return isBuiltinClass.profileClass(inliningTarget, clazz, type);
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsAnyBuiltinObjectProfile
    extends Node {
        public final boolean profileIsAnyBuiltinObject(Node inliningTarget, Object obj) {
            return this.execute(inliningTarget, obj);
        }

        abstract boolean execute(Node var1, Object var2);

        @Specialization
        static boolean doIt(Node inliningTarget, Object obj, @Cached GetClassNode getClassNode, @Cached IsAnyBuiltinClassProfile isAnyBuiltinClass) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            return isAnyBuiltinClass.execute(inliningTarget, clazz);
        }
    }

    @GenerateInline
    public static abstract class InlineIsBuiltinClassProfile
    extends IsBuiltinClassExactProfile {
        public final boolean profileClassCached(Object clazz, PythonBuiltinClassType pythonClass) {
            return this.execute(this, clazz, pythonClass);
        }

        public static InlineIsBuiltinClassProfile create() {
            return BuiltinClassProfilesFactory.InlineIsBuiltinClassProfileNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IsBuiltinClassProfile
    extends Node {
        public static IsBuiltinClassProfile getUncached() {
            return BuiltinClassProfilesFactory.IsBuiltinClassProfileNodeGen.getUncached();
        }

        public static boolean profileClassSlowPath(Object clazz, PythonBuiltinClassType type) {
            return IsBuiltinClassProfile.getUncached().profileClass(null, clazz, type);
        }

        public final boolean profileClass(Node inliningTarget, Object type, PythonBuiltinClassType pythonClass) {
            return this.execute(inliningTarget, type, pythonClass);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization(guards={"sameType(clazz, pythonClass)"})
        static boolean doSameType(PythonBuiltinClassType clazz, PythonBuiltinClassType pythonClass) {
            return true;
        }

        @Specialization(guards={"sameType(clazz, pythonClass)"})
        static boolean doSameType(PythonBuiltinClass clazz, PythonBuiltinClassType pythonClass) {
            return true;
        }

        @Specialization
        static boolean doOthers(Node inliningTarget, Object clazz, PythonBuiltinClassType pythonClass, @Cached InlinedConditionProfile profile, @Cached(inline=false) IsSubtypeNode isSubtypeNode) {
            return profile.profile(inliningTarget, isSubtypeNode.execute(clazz, (Object)pythonClass));
        }

        protected static boolean sameType(PythonBuiltinClassType a, PythonBuiltinClassType b) {
            return a == b;
        }

        protected static boolean sameType(PythonBuiltinClass a, PythonBuiltinClassType b) {
            return a.getType() == b;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IsBuiltinClassExactProfile
    extends Node {
        public final boolean profileClass(Node inliningTarget, Object type, PythonBuiltinClassType pythonClass) {
            return this.execute(inliningTarget, type, pythonClass);
        }

        public static boolean profileClassSlowPath(Object type, PythonBuiltinClassType pythonClass) {
            return IsBuiltinClassExactProfile.getUncached().execute(null, type, pythonClass);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization
        static boolean doType(Node inliningTarget, PythonBuiltinClassType clazz, PythonBuiltinClassType pythonClass, @Cached.Shared @Cached InlinedConditionProfile profile) {
            return profile.profile(inliningTarget, clazz == pythonClass);
        }

        @Specialization
        static boolean doClass(Node inliningTarget, PythonBuiltinClass clazz, PythonBuiltinClassType pythonClass, @Cached.Shared @Cached InlinedConditionProfile profile) {
            return profile.profile(inliningTarget, clazz.getType() == pythonClass);
        }

        @Fallback
        static boolean doOthers(Object clazz, PythonBuiltinClassType pythonClass) {
            return false;
        }

        public static IsBuiltinClassExactProfile getUncached() {
            return BuiltinClassProfilesFactory.IsBuiltinClassExactProfileNodeGen.getUncached();
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsOtherBuiltinClassProfile
    extends Node {
        public final boolean profileIsOtherBuiltinClass(Node inliningTarget, Object clazz, PythonBuiltinClassType forbiddenType) {
            return this.execute(inliningTarget, clazz, forbiddenType);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization
        static boolean doType(Node inliningTarget, PythonBuiltinClassType clazz, PythonBuiltinClassType forbiddenType) {
            return clazz != forbiddenType;
        }

        @Specialization
        static boolean doClass(Node inliningTarget, PythonBuiltinClass clazz, PythonBuiltinClassType forbiddenType) {
            return clazz.getType() != forbiddenType;
        }

        @Fallback
        static boolean doOthers(Node inliningTarget, Object clazz, PythonBuiltinClassType forbiddenType) {
            return false;
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsAnyBuiltinClassProfile
    extends Node {
        public final boolean profileIsAnyBuiltinClass(Node inliningTarget, Object clazz) {
            return this.execute(inliningTarget, clazz);
        }

        abstract boolean execute(Node var1, Object var2);

        @Specialization
        static boolean doType(Node inliningTarget, PythonBuiltinClassType clazz) {
            return true;
        }

        @Specialization
        static boolean doClass(Node inliningTarget, PythonBuiltinClass clazz) {
            return true;
        }

        @Fallback
        static boolean doOthers(Node inliningTarget, Object clazz) {
            return false;
        }
    }
}

