/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import javax.net.ssl.SSLSocketFactory;
import org.italiangrid.voms.request.SSLSocketFactoryProvider;
import org.italiangrid.voms.request.VOMSProtocol;
import org.italiangrid.voms.request.VOMSProtocolListener;
import org.italiangrid.voms.util.NullListener;

public abstract class AbstractVOMSProtocol
implements VOMSProtocol {
    public static final String[] VOMS_LEGACY_PROTOCOLS = new String[]{"SSLv3"};
    public static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    public static final boolean DEFAULT_SKIP_HOSTNAME_CHECKS = false;
    protected VOMSProtocolListener listener = NullListener.INSTANCE;
    protected X509CertChainValidatorExt validator;
    protected int connectTimeout = 2000;
    protected int readTimeout = 5000;
    protected boolean skipHostnameChecks = false;

    public AbstractVOMSProtocol(X509CertChainValidatorExt validator) {
        this.validator = validator;
    }

    public AbstractVOMSProtocol(X509CertChainValidatorExt validator, VOMSProtocolListener listener, int connectTimeout, int readTimeout) {
        this.validator = validator;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.listener = listener;
    }

    protected SSLSocketFactory getSSLSocketFactory(X509Credential credential) {
        SSLSocketFactoryProvider sslSocketFactoryProvider = new SSLSocketFactoryProvider(credential, this.validator);
        return sslSocketFactoryProvider.getSSLSockectFactory();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isSkipHostnameChecks() {
        return this.skipHostnameChecks;
    }

    public void setSkipHostnameChecks(boolean skipHostnameChecks) {
        this.skipHostnameChecks = skipHostnameChecks;
    }
}

