/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.store.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.store.LSCFileParser;
import org.italiangrid.voms.store.impl.LSCFile;

public class DefaultLSCFileParser
implements LSCFileParser {
    public static final String EMPTY_LINE_REGEX = "(?m)^\\s*?$";
    public static final String MALFORMED_LSC_FILE_ERROR_TEMPLATE = "LSC file parsing error: Malformed LSC file (vo=%s, host=%s): %s";

    private void checkFileExistanceAndReadabilty(File f) {
        if (!f.exists()) {
            throw new VOMSError("LSC file does not exist: " + f.getAbsolutePath());
        }
        if (!f.canRead()) {
            throw new VOMSError("LSC file is not readable: " + f.getAbsolutePath());
        }
    }

    public LSCFile parse(String vo, String hostname, String filename) {
        LSCFile lsc = null;
        try {
            File f = new File(filename);
            this.checkFileExistanceAndReadabilty(f);
            lsc = this.parse(vo, hostname, new FileInputStream(f));
            lsc.setFilename(filename);
        }
        catch (IOException e) {
            throw new VOMSError("LSC file parsing error: " + e.getMessage(), e);
        }
        return lsc;
    }

    public synchronized LSCFile parse(String vo, String hostname, InputStream is) {
        LSCFile lsc = new LSCFile();
        lsc.setHostname(hostname);
        lsc.setVo(vo);
        try {
            BufferedReader lscReader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            ArrayList<String> certificateChainDescription = new ArrayList<String>();
            while ((line = lscReader.readLine()) != null) {
                if (!line.startsWith("#") && !line.startsWith("-") && !line.matches(EMPTY_LINE_REGEX) && line.startsWith("/")) {
                    certificateChainDescription.add(line);
                }
                if (line != null) continue;
            }
            lscReader.close();
            if (certificateChainDescription.size() % 2 != 0) {
                String errorMessage = String.format(MALFORMED_LSC_FILE_ERROR_TEMPLATE, vo, hostname, "Odd number of distinguished name entries.");
                throw new VOMSError(errorMessage);
            }
            if (certificateChainDescription.size() == 0) {
                String errorMessage = String.format(MALFORMED_LSC_FILE_ERROR_TEMPLATE, vo, hostname, "No distinguished name entries found.");
                throw new VOMSError(errorMessage);
            }
            lsc.setCertificateChainDescription(certificateChainDescription);
        }
        catch (IOException e) {
            throw new VOMSError("LSC file parsing error: " + e.getMessage(), e);
        }
        return lsc;
    }

    public LSCFile parse(String vo, String hostname, File file) {
        LSCFile lsc = null;
        try {
            this.checkFileExistanceAndReadabilty(file);
            lsc = this.parse(vo, hostname, new FileInputStream(file));
            lsc.setFilename(file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new VOMSError("LSC file parsing error: " + e.getMessage(), e);
        }
        return lsc;
    }
}

