/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.io.IOException;
import org.jodconverter.core.office.AbstractRetryable;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.TemporaryException;
import org.jodconverter.core.util.OSUtils;
import org.jodconverter.local.office.OfficeConnection;
import org.jodconverter.local.office.OfficeConnectionException;
import org.jodconverter.local.office.VerboseProcess;
import org.jodconverter.local.process.ProcessManager;
import org.jodconverter.local.process.ProcessQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StartProcessAndConnectRetryable
extends AbstractRetryable<Exception> {
    private static final long FREEBSD_FIND_PID_DELAY = 2000L;
    private static final int FIND_PID_RETRIES = 10;
    private static final long FIND_PID_INTERVAL = 250L;
    private static final Integer EXIT_CODE_81 = 81;
    private static final long NO_DELAY = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StartProcessAndConnectRetryable.class);
    private final ProcessManager processManager;
    private final ProcessBuilder processBuilder;
    private final ProcessQuery processQuery;
    private final long afterStartProcessDelay;
    private final OfficeConnection connection;
    private StartProcessResult result;

    StartProcessAndConnectRetryable(ProcessManager processManager, ProcessBuilder processBuilder, ProcessQuery processQuery, long afterStartProcessDelay, OfficeConnection connection) {
        this.processManager = processManager;
        this.processBuilder = processBuilder;
        this.processQuery = processQuery;
        this.afterStartProcessDelay = afterStartProcessDelay;
        this.connection = connection;
    }

    protected void attempt() throws Exception {
        if (this.result == null) {
            this.result = this.startProcess();
            this.checkProcessAlive();
            this.checkProcessId();
        }
        try {
            this.connection.connect();
            LOGGER.trace("An attempt to connect to an office process succeeded");
        }
        catch (OfficeConnectionException ex) {
            LOGGER.trace("An attempt to connect to an office process has failed", (Throwable)((Object)ex));
            this.handleConnectionFailure(ex);
        }
    }

    public VerboseProcess getProcess() {
        return this.result == null ? null : this.result.process;
    }

    public long getProcessId() {
        return this.result == null ? -1L : this.result.pid;
    }

    private StartProcessResult startProcess() throws IOException {
        StartProcessResult attemptResult = new StartProcessResult();
        attemptResult.process = new VerboseProcess(this.processBuilder.start());
        if (this.afterStartProcessDelay > 0L) {
            LOGGER.debug("Waiting for process to start...");
            this.sleep(this.afterStartProcessDelay);
        } else if (OSUtils.IS_OS_FREE_BSD) {
            LOGGER.debug("Waiting for process to start on FreeBSD...");
            this.sleep(2000L);
        }
        int tryCount = 0;
        while (true) {
            LOGGER.debug("Trying to find pid, attempt #{}", (Object)(++tryCount));
            if (this.findPid(attemptResult, tryCount)) {
                return attemptResult;
            }
            this.sleep(250L);
        }
    }

    private boolean findPid(StartProcessResult attemptResult, int tryCount) throws IOException {
        try {
            attemptResult.exitCode = attemptResult.process.getProcess().exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            if (!this.processManager.canFindPid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The current process manager does not support finding the pid: {}", (Object)this.processManager.getClass().getName());
                }
                return true;
            }
            attemptResult.pid = this.processManager.findPid(this.processQuery);
            return attemptResult.pid > -1L || tryCount == 10;
        }
    }

    private void checkProcessAlive() throws TemporaryException, OfficeException {
        if (this.result.exitCode != null) {
            if (this.result.exitCode.equals(EXIT_CODE_81)) {
                LOGGER.warn("Office process died with exit code 81; restarting it");
                this.result = null;
                throw new TemporaryException("Office process died with exit code 81");
            }
            throw new OfficeException("Office process died with exit code: " + this.result.exitCode);
        }
    }

    private void checkProcessId() throws TemporaryException {
        if (this.processManager.canFindPid() && this.result.pid <= -1L) {
            try {
                this.result.process.getProcess().destroy();
            }
            catch (Exception ex) {
                LOGGER.warn("Could not destroy the process", (Throwable)ex);
            }
            this.result = null;
            throw new TemporaryException(String.format("A process with --accept '%s' started but its pid could not be found; restarting", this.processQuery.getArgument()));
        }
    }

    private void handleConnectionFailure(OfficeConnectionException ex) throws TemporaryException, OfficeException {
        Integer exitCode = this.result.process.getExitCode();
        if (exitCode == null) {
            throw new TemporaryException((Throwable)((Object)ex));
        }
        if (exitCode.equals(EXIT_CODE_81)) {
            this.result = null;
            LOGGER.warn("Office process died with exit code 81; restarting it");
            throw new TemporaryException((Throwable)((Object)ex));
        }
        throw new OfficeException("Office process died with exit code " + exitCode, (Throwable)((Object)ex));
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    private static class StartProcessResult {
        VerboseProcess process;
        long pid = -1L;
        Integer exitCode;

        private StartProcessResult() {
        }
    }
}

