/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.spring;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.Module;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringService
implements FactoryBean,
ServletContextAware,
InitializingBean {
    @NotNull
    private Class<?> implType;
    private Invoker invoker;
    private QName serviceName;
    private QName portName;
    private Container container;
    private SDDocumentSource primaryWsdl;
    private Object primaryWSDLResource;
    private Collection<? extends SDDocumentSource> metadata;
    private Collection<Object> metadataResources;
    private EntityResolver resolver;
    private Object assembler;
    private WSBinding binding;
    private BindingID bindingID;
    private List<WebServiceFeature> features;
    private List<Handler> handlers;
    private ServletContext servletContext;
    private WSEndpoint<?> endpoint;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setImpl(Class implType) {
        this.implType = implType;
    }

    public void setBean(Object sei) {
        this.invoker = InstanceResolver.createSingleton((Object)sei).createInvoker();
        if (this.implType == null) {
            this.implType = sei.getClass();
        }
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setAssembler(Object assembler) {
        if (!(assembler instanceof TubelineAssembler) && !(assembler instanceof TubelineAssemblerFactory)) {
            throw new IllegalArgumentException("Invalid type for assembler " + assembler);
        }
        this.assembler = assembler;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public void setPortName(QName portName) {
        this.portName = portName;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setBinding(WSBinding binding) {
        this.binding = binding;
    }

    public void setBindingID(String id) {
        this.bindingID = BindingID.parse((String)id);
    }

    public void setFeatures(List<WebServiceFeature> features) {
        this.features = features;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public void setPrimaryWsdl(Object primaryWsdl) throws IOException {
        this.primaryWSDLResource = primaryWsdl;
    }

    public void setMetadata(Collection<Object> metadata) {
        this.metadataResources = metadata;
    }

    public void setResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public WSEndpoint getObject() throws Exception {
        if (this.endpoint == null) {
            EntityResolver resolver;
            if (this.binding == null) {
                if (this.bindingID == null) {
                    this.bindingID = BindingID.parse(this.implType);
                }
                this.binding = this.features == null || this.features.isEmpty() ? BindingImpl.create((BindingID)this.bindingID) : BindingImpl.create((BindingID)this.bindingID, (WebServiceFeature[])this.features.toArray(new WebServiceFeature[this.features.size()]));
            } else {
                if (this.bindingID != null) {
                    throw new IllegalStateException("Both bindingID and binding are configured");
                }
                if (this.features != null) {
                    throw new IllegalStateException("Both features and binding are configured");
                }
            }
            if (this.handlers != null) {
                List chain = this.binding.getHandlerChain();
                chain.addAll(this.handlers);
                this.binding.setHandlerChain(chain);
            }
            if (this.primaryWsdl == null) {
                EndpointFactory.verifyImplementorClass(this.implType);
                String wsdlLocation = EndpointFactory.getWsdlLocation(this.implType);
                if (wsdlLocation != null) {
                    this.primaryWsdl = this.convertStringToSource(wsdlLocation);
                }
            }
            if ((resolver = this.resolver) == null) {
                resolver = this.servletContext != null ? XmlUtil.createEntityResolver((URL)this.servletContext.getResource("/WEB-INF/jax-ws-catalog.xml")) : XmlUtil.createEntityResolver((URL)this.getClass().getClassLoader().getResource("/META-INF/jax-ws-catalog.xml"));
            }
            this.endpoint = WSEndpoint.create(this.implType, (boolean)false, (Invoker)this.invoker, (QName)this.serviceName, (QName)this.portName, (Container)new ContainerWrapper(), (WSBinding)this.binding, (SDDocumentSource)this.primaryWsdl, this.metadata, (EntityResolver)resolver, (boolean)true);
        }
        return this.endpoint;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.primaryWSDLResource != null) {
            this.primaryWsdl = this.resolveSDDocumentSource(this.primaryWSDLResource);
        }
        if (this.metadataResources != null) {
            ArrayList<? extends SDDocumentSource> tempList = new ArrayList<SDDocumentSource>(this.metadataResources.size());
            for (Object resource : this.metadataResources) {
                tempList.add((SDDocumentSource)this.resolveSDDocumentSource(resource));
            }
            this.metadata = tempList;
        }
    }

    private SDDocumentSource resolveSDDocumentSource(Object resource) {
        SDDocumentSource source;
        if (resource instanceof String) {
            source = this.convertStringToSource((String)resource);
        } else if (resource instanceof URL) {
            source = SDDocumentSource.create((URL)((URL)resource));
        } else if (resource instanceof SDDocumentSource) {
            source = (SDDocumentSource)resource;
        } else {
            throw new IllegalArgumentException("Unknown type " + resource);
        }
        return source;
    }

    private SDDocumentSource convertStringToSource(String resourceLocation) {
        URL url = null;
        if (this.servletContext != null) {
            try {
                url = this.servletContext.getResource(resourceLocation);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (url == null) {
            ClassLoader cl = this.implType.getClassLoader();
            url = cl.getResource(resourceLocation);
        }
        if (url == null) {
            try {
                url = new URL(resourceLocation);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            throw new ServerRtException("cannot.load.wsdl", new Object[]{resourceLocation});
        }
        return SDDocumentSource.create((URL)url);
    }

    public boolean isSingleton() {
        return true;
    }

    public Class getObjectType() {
        return WSEndpoint.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerWrapper
    extends Container {
        private final Module module = new Module(){
            private final List<BoundEndpoint> endpoints = new ArrayList<BoundEndpoint>();

            @NotNull
            public List<BoundEndpoint> getBoundEndpoints() {
                return this.endpoints;
            }
        };

        private ContainerWrapper() {
        }

        public <T> T getSPI(Class<T> spiType) {
            Object t;
            if (spiType == TubelineAssemblerFactory.class) {
                if (SpringService.this.assembler instanceof TubelineAssemblerFactory) {
                    return spiType.cast(SpringService.this.assembler);
                }
                if (SpringService.this.assembler instanceof TubelineAssembler) {
                    return spiType.cast(new TubelineAssemblerFactory(){

                        public TubelineAssembler doCreate(BindingID bindingId) {
                            return (TubelineAssembler)SpringService.this.assembler;
                        }
                    });
                }
            }
            if (SpringService.this.container != null && (t = SpringService.this.container.getSPI(spiType)) != null) {
                return (T)t;
            }
            if (spiType == Module.class) {
                return spiType.cast(this.module);
            }
            return null;
        }
    }
}

