/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.v1.service;

import java.io.IOException;
import java.util.ArrayList;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexCurrenciesResponse;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexCurrency;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexDepth;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexDepthResponse;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexSymbolsResponse;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexTicker;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexTickerResponse;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexTickersResponse;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexTrade;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexTradesResponse;
import org.knowm.xchange.bittrex.v1.service.BittrexBaseService;
import org.knowm.xchange.exceptions.ExchangeException;

public class BittrexMarketDataServiceRaw
extends BittrexBaseService {
    public BittrexMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public BittrexCurrency[] getBittrexCurrencies() throws IOException {
        BittrexCurrenciesResponse response = this.bittrexAuthenticated.getCurrencies();
        if (response.isSuccess()) {
            return response.getCurrencies();
        }
        throw new ExchangeException(response.getMessage());
    }

    public ArrayList<BittrexSymbol> getBittrexSymbols() throws IOException {
        BittrexSymbolsResponse response = this.bittrexAuthenticated.getSymbols();
        if (response.isSuccess()) {
            return response.getSymbols();
        }
        throw new ExchangeException(response.getMessage());
    }

    public BittrexTicker getBittrexTicker(String pair) throws IOException {
        BittrexTickerResponse response = this.bittrexAuthenticated.getTicker(pair);
        if (response.getSuccess()) {
            return response.getTicker();
        }
        throw new ExchangeException(response.getMessage());
    }

    public ArrayList<BittrexTicker> getBittrexTickers() throws IOException {
        BittrexTickersResponse response = this.bittrexAuthenticated.getTickers();
        if (response.isSuccess()) {
            return response.getTickers();
        }
        throw new ExchangeException(response.getMessage());
    }

    public BittrexDepth getBittrexOrderBook(String pair, int depth) throws IOException {
        BittrexDepthResponse response = this.bittrexAuthenticated.getBook(pair, "both", depth);
        if (response.getSuccess()) {
            BittrexDepth bittrexDepth = response.getDepth();
            return bittrexDepth;
        }
        throw new ExchangeException(response.getMessage());
    }

    public BittrexTrade[] getBittrexTrades(String pair, int count) throws IOException {
        BittrexTradesResponse response = this.bittrexAuthenticated.getTrades(pair, count);
        if (response.getSuccess()) {
            BittrexTrade[] bittrexTrades = response.getTrades();
            return bittrexTrades;
        }
        throw new ExchangeException(response.getMessage());
    }
}

