/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.v1.service;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.v1.BittrexAdapters;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexUserTrade;
import org.knowm.xchange.bittrex.v1.service.BittrexTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsZero;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class BittrexTradeService
extends BittrexTradeServiceRaw
implements TradeService {
    public BittrexTradeService(Exchange exchange) {
        super(exchange);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        String id = this.placeBittrexMarketOrder(marketOrder);
        return id;
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        String id = this.placeBittrexLimitOrder(limitOrder);
        return id;
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        return new OpenOrders(BittrexAdapters.adaptOpenOrders(this.getBittrexOpenOrders(params)));
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return this.cancelBittrexLimitOrder(orderId);
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            this.cancelOrder(((CancelOrderByIdParams)orderParams).orderId);
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        CurrencyPair currencyPair = null;
        if (params instanceof TradeHistoryParamCurrencyPair) {
            TradeHistoryParamCurrencyPair tradeHistoryParamCurrencyPair = (TradeHistoryParamCurrencyPair)params;
            currencyPair = tradeHistoryParamCurrencyPair.getCurrencyPair();
        }
        List<BittrexUserTrade> bittrexTradeHistory = this.getBittrexTradeHistory(currencyPair);
        return new UserTrades(BittrexAdapters.adaptUserTrades(bittrexTradeHistory), Trades.TradeSortType.SortByTimestamp);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return TradeHistoryParamsZero.PARAMS_ZERO;
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

