/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.ClientSessionBinding;
import com.mongodb.async.client.ClientSessionHelper;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.binding.AsyncClusterBinding;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;

class OperationExecutorImpl
implements OperationExecutor {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoClientImpl mongoClient;
    private final ClientSessionHelper clientSessionHelper;

    OperationExecutorImpl(MongoClientImpl mongoClient, ClientSessionHelper clientSessionHelper) {
        this.mongoClient = mongoClient;
        this.clientSessionHelper = clientSessionHelper;
    }

    @Override
    public <T> void execute(AsyncReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern, SingleResultCallback<T> callback) {
        this.execute(operation, readPreference, readConcern, null, callback);
    }

    @Override
    public <T> void execute(final AsyncReadOperation<T> operation, final ReadPreference readPreference, final ReadConcern readConcern, final @Nullable ClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        this.clientSessionHelper.withClientSession(session, this, new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    AsyncReadWriteBinding binding = OperationExecutorImpl.this.getReadWriteBinding(readPreference, readConcern, clientSession, session == null && clientSession != null);
                    if (session != null && session.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                        throw new MongoClientException("Read preference in a transaction must be primary");
                    }
                    operation.executeAsync((AsyncReadBinding)binding, new SingleResultCallback<T>((AsyncReadBinding)binding){
                        final /* synthetic */ AsyncReadBinding val$binding;
                        {
                            this.val$binding = asyncReadBinding;
                        }

                        public void onResult(T result, Throwable t) {
                            try {
                                OperationExecutorImpl.this.labelException(t, session);
                                errHandlingCallback.onResult(result, t);
                            }
                            finally {
                                this.val$binding.release();
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public <T> void execute(AsyncWriteOperation<T> operation, ReadConcern readConcern, SingleResultCallback<T> callback) {
        this.execute(operation, readConcern, null, callback);
    }

    @Override
    public <T> void execute(final AsyncWriteOperation<T> operation, final ReadConcern readConcern, final @Nullable ClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        this.clientSessionHelper.withClientSession(session, this, new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    AsyncReadWriteBinding binding = OperationExecutorImpl.this.getReadWriteBinding(ReadPreference.primary(), readConcern, clientSession, session == null && clientSession != null);
                    operation.executeAsync((AsyncWriteBinding)binding, new SingleResultCallback<T>((AsyncWriteBinding)binding){
                        final /* synthetic */ AsyncWriteBinding val$binding;
                        {
                            this.val$binding = asyncWriteBinding;
                        }

                        public void onResult(T result, Throwable t) {
                            try {
                                OperationExecutorImpl.this.labelException(t, session);
                                errHandlingCallback.onResult(result, t);
                            }
                            finally {
                                this.val$binding.release();
                            }
                        }
                    });
                }
            }
        });
    }

    private void labelException(Throwable t, ClientSession session) {
        if ((t instanceof MongoSocketException || t instanceof MongoTimeoutException) && session != null && session.hasActiveTransaction() && !((MongoException)t).hasErrorLabel("UnknownTransactionCommitResult")) {
            ((MongoException)t).addLabel("TransientTransactionError");
        }
    }

    private AsyncReadWriteBinding getReadWriteBinding(ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Object readWriteBinding = new AsyncClusterBinding(this.mongoClient.getCluster(), this.getReadPreferenceForBinding(readPreference, session), readConcern);
        if (session != null) {
            readWriteBinding = new ClientSessionBinding(session, ownsSession, (AsyncReadWriteBinding)readWriteBinding);
        }
        return readWriteBinding;
    }

    private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession session) {
        if (session == null) {
            return readPreference;
        }
        if (session.hasActiveTransaction()) {
            ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
            if (readPreferenceForBinding == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
            }
            return readPreferenceForBinding;
        }
        return readPreference;
    }
}

