/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.utils.ModelUtils;

public class TypeScriptFetchClientCodegen
extends AbstractTypeScriptClientCodegen {
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String USE_SINGLE_REQUEST_PARAMETER = "useSingleRequestParameter";
    public static final String PREFIX_PARAMETER_INTERFACES = "prefixParameterInterfaces";
    public static final String TYPESCRIPT_THREE_PLUS = "typescriptThreePlus";
    protected String npmRepository = null;
    private boolean useSingleRequestParameter = true;
    private boolean prefixParameterInterfaces = false;
    protected boolean addedApiIndex = false;
    protected boolean addedModelIndex = false;
    protected boolean typescriptThreePlus = false;

    public TypeScriptFetchClientCodegen() {
        this.featureSet = this.getFeatureSet().modify().includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).build();
        this.importMapping.clear();
        this.outputFolder = "generated-code/typescript-fetch";
        this.templateDir = "typescript-fetch";
        this.embeddedTemplateDir = "typescript-fetch";
        this.apiTemplateFiles.put("apis.mustache", ".ts");
        this.modelTemplateFiles.put("models.mustache", ".ts");
        this.addExtraReservedWords();
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(USE_SINGLE_REQUEST_PARAMETER, "Setting this property to true will generate functions with a single argument containing all API endpoint parameters instead of one argument per parameter.", "boolean").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(PREFIX_PARAMETER_INTERFACES, "Setting this property to true will generate parameter interface declarations prefixed with API class name to avoid name conflicts.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(TYPESCRIPT_THREE_PLUS, "Setting this property to true will generate TypeScript 3.6+ compatible code.", "boolean").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    public String getName() {
        return "typescript-fetch";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library using Fetch API (beta).";
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    public Boolean getTypescriptThreePlus() {
        return this.typescriptThreePlus;
    }

    public void setTypescriptThreePlus(Boolean typescriptThreePlus) {
        this.typescriptThreePlus = typescriptThreePlus;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put("isOriginalModelPropertyNaming", this.getModelPropertyNaming().equals("original"));
        this.additionalProperties.put("modelPropertyNaming", this.getModelPropertyNaming());
        String sourceDir = "";
        if (this.additionalProperties.containsKey("npmName")) {
            sourceDir = "src" + File.separator;
        }
        this.apiPackage = sourceDir + "apis";
        this.modelPackage = sourceDir + "models";
        this.supportingFiles.add(new SupportingFile("index.mustache", sourceDir, "index.ts"));
        this.supportingFiles.add(new SupportingFile("runtime.mustache", sourceDir, "runtime.ts"));
        if (this.additionalProperties.containsKey(USE_SINGLE_REQUEST_PARAMETER)) {
            this.setUseSingleRequestParameter(this.convertPropertyToBoolean(USE_SINGLE_REQUEST_PARAMETER));
        }
        this.writePropertyBack(USE_SINGLE_REQUEST_PARAMETER, this.getUseSingleRequestParameter());
        if (this.additionalProperties.containsKey(PREFIX_PARAMETER_INTERFACES)) {
            this.setPrefixParameterInterfaces(this.convertPropertyToBoolean(PREFIX_PARAMETER_INTERFACES));
        }
        this.writePropertyBack(PREFIX_PARAMETER_INTERFACES, this.getPrefixParameterInterfaces());
        if (this.additionalProperties.containsKey("npmName")) {
            this.addNpmPackageGeneration();
        }
        if (this.additionalProperties.containsKey(TYPESCRIPT_THREE_PLUS)) {
            this.setTypescriptThreePlus(this.convertPropertyToBoolean(TYPESCRIPT_THREE_PLUS));
        }
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema inner = ((ArraySchema)p).getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "{ [key: string]: " + this.getTypeDeclaration(inner) + "; }";
        }
        if (ModelUtils.isFileSchema(p)) {
            return "Blob";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "Blob";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "Date";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "Date";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)this.postProcessModelsEnum(objs).get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent != null) {
                for (CodegenProperty var : cm.allVars) {
                    if (!Boolean.TRUE.equals(var.isEnum)) continue;
                    var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                }
            }
            if (cm.oneOf.isEmpty()) continue;
            TreeSet<String> oneOfRefs = new TreeSet<String>();
            for (String im : cm.imports) {
                if (!cm.oneOf.contains(im)) continue;
                oneOfRefs.add(im);
            }
            cm.imports = oneOfRefs;
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map model : models) {
                CodegenModel codegenModel = (CodegenModel)model.get("model");
                model.put("hasImports", codegenModel.imports.size() > 0);
            }
        }
        return result;
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
        this.supportingFiles.add(new SupportingFile("npmignore.mustache", "", ".npmignore"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> allModels) {
        if (operations.size() > 0 && !this.addedApiIndex) {
            this.addedApiIndex = true;
            this.supportingFiles.add(new SupportingFile("apis.index.mustache", this.apiPackage().replace('.', File.separatorChar), "index.ts"));
        }
        if (allModels.size() > 0 && !this.addedModelIndex) {
            this.addedModelIndex = true;
            this.supportingFiles.add(new SupportingFile("models.index.mustache", this.modelPackage().replace('.', File.separatorChar), "index.ts"));
        }
        this.addOperationModelImportInfomation(operations);
        this.updateOperationParameterEnumInformation(operations);
        this.addOperationObjectResponseInformation(operations);
        this.addOperationPrefixParameterInterfacesInformation(operations);
        return operations;
    }

    private void addOperationModelImportInfomation(Map<String, Object> operations) {
        List imports = (List)operations.get("imports");
        for (Map im : imports) {
            im.put("className", im.get("import").toString().replace(this.modelPackage() + ".", ""));
        }
    }

    private void updateOperationParameterEnumInformation(Map<String, Object> operations) {
        Map _operations = (Map)operations.get("operations");
        List operationList = (List)_operations.get("operation");
        boolean hasEnum = false;
        for (CodegenOperation op : operationList) {
            for (CodegenParameter param : op.allParams) {
                if (!Boolean.TRUE.equals(param.isEnum)) continue;
                hasEnum = true;
                param.datatypeWithEnum = param.datatypeWithEnum.replace(param.enumName, op.operationIdCamelCase + param.enumName);
            }
        }
        operations.put("hasEnums", hasEnum);
    }

    private void addOperationObjectResponseInformation(Map<String, Object> operations) {
        Map _operations = (Map)operations.get("operations");
        List operationList = (List)_operations.get("operation");
        for (CodegenOperation op : operationList) {
            if (!"object".equals(op.returnType)) continue;
            op.isMapContainer = true;
            op.returnSimpleType = false;
        }
    }

    private void addOperationPrefixParameterInterfacesInformation(Map<String, Object> operations) {
        Map _operations = (Map)operations.get("operations");
        operations.put(PREFIX_PARAMETER_INTERFACES, this.getPrefixParameterInterfaces());
    }

    private void addExtraReservedWords() {
        this.reservedWords.add("BASE_PATH");
        this.reservedWords.add("BaseAPI");
        this.reservedWords.add("RequiredError");
        this.reservedWords.add("COLLECTION_FORMATS");
        this.reservedWords.add("FetchAPI");
        this.reservedWords.add("ConfigurationParameters");
        this.reservedWords.add("Configuration");
        this.reservedWords.add("configuration");
        this.reservedWords.add("HTTPMethod");
        this.reservedWords.add("HTTPHeaders");
        this.reservedWords.add("HTTPQuery");
        this.reservedWords.add("HTTPBody");
        this.reservedWords.add("ModelPropertyNaming");
        this.reservedWords.add("FetchParams");
        this.reservedWords.add("RequestOpts");
        this.reservedWords.add("exists");
        this.reservedWords.add("RequestContext");
        this.reservedWords.add("ResponseContext");
        this.reservedWords.add("Middleware");
        this.reservedWords.add("ApiResponse");
        this.reservedWords.add("ResponseTransformer");
        this.reservedWords.add("JSONApiResponse");
        this.reservedWords.add("VoidApiResponse");
        this.reservedWords.add("BlobApiResponse");
        this.reservedWords.add("TextApiResponse");
    }

    private boolean getUseSingleRequestParameter() {
        return this.useSingleRequestParameter;
    }

    private void setUseSingleRequestParameter(boolean useSingleRequestParameter) {
        this.useSingleRequestParameter = useSingleRequestParameter;
    }

    private boolean getPrefixParameterInterfaces() {
        return this.prefixParameterInterfaces;
    }

    private void setPrefixParameterInterfaces(boolean prefixParameterInterfaces) {
        this.prefixParameterInterfaces = prefixParameterInterfaces;
    }
}

