/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static String underscore(String word) {
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        String result = word.replaceAll("\\.", "/");
        result = result.replaceAll("\\$", "__");
        result = result.replaceAll(firstPattern, replacementPattern);
        result = result.replaceAll(secondPattern, replacementPattern);
        result = result.replace('-', '_');
        result = result.replace(' ', '_');
        result = result.toLowerCase(Locale.ROOT);
        return result;
    }

    public static String dashize(String word) {
        return StringUtils.underscore(word).replaceAll("[_ ]+", "-");
    }

    public static String camelize(String word) {
        return StringUtils.camelize(word, false);
    }

    public static String camelize(String word, boolean lowercaseFirstLetter) {
        Pattern p = Pattern.compile("\\/(.?)");
        Matcher m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher(word);
        }
        String[] parts = word.split("\\.");
        StringBuilder f = new StringBuilder();
        for (String z : parts) {
            if (z.length() <= 0) continue;
            f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
        }
        word = f.toString();
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("" + Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
            m = p.matcher(word);
        }
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher(word);
        if (m.find()) {
            String rep = m.group(1) + m.group(2).toUpperCase(Locale.ROOT) + m.group(3);
            rep = rep.replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll(rep);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher(word);
        while (m.find()) {
            String upperCase;
            String original = m.group(2);
            word = original.equals(upperCase = original.toUpperCase(Locale.ROOT)) ? word.replaceFirst("_", "") : m.replaceFirst(upperCase);
            m = p.matcher(word);
        }
        p = Pattern.compile("(-)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst(m.group(2).toUpperCase(Locale.ROOT));
            m = p.matcher(word);
        }
        if (lowercaseFirstLetter && word.length() > 0) {
            int i = 0;
            char charAt = word.charAt(i);
            while (!(i + 1 >= word.length() || charAt >= 'a' && charAt <= 'z' || charAt >= 'A' && charAt <= 'Z')) {
                charAt = word.charAt(++i);
            }
            word = word.substring(0, ++i).toLowerCase(Locale.ROOT) + word.substring(i);
        }
        word = word.replaceAll("_", "");
        return word;
    }

    public static String escape(String name, Map<String, String> replacementMap, List<String> charactersToAllow, String appendToReplacement) {
        String result = name.chars().mapToObj(c -> {
            String character = "" + (char)c;
            if (charactersToAllow != null && charactersToAllow.contains(character)) {
                return character;
            }
            if (replacementMap.containsKey(character)) {
                return (String)replacementMap.get(character) + (appendToReplacement != null ? appendToReplacement : "");
            }
            return character;
        }).reduce((c1, c2) -> "" + c1 + c2).orElse(null);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Word '" + name + "' could not be escaped.");
    }
}

