/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPlayFrameworkCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures {
    private final Logger LOGGER = LoggerFactory.getLogger(JavaPlayFrameworkCodegen.class);
    public static final String TITLE = "title";
    public static final String CONFIG_PACKAGE = "configPackage";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String CONTROLLER_ONLY = "controllerOnly";
    public static final String USE_INTERFACES = "useInterfaces";
    public static final String HANDLE_EXCEPTIONS = "handleExceptions";
    public static final String WRAP_CALLS = "wrapCalls";
    public static final String USE_SWAGGER_UI = "useSwaggerUI";
    public static final String SUPPORT_ASYNC = "supportAsync";
    private static final String X_JWKS_URL = "x-jwksUrl";
    private static final String X_TOKEN_INTROSPECT_URL = "x-tokenIntrospectUrl";
    protected String title = "openapi-java-playframework";
    protected String configPackage = "org.openapitools.configuration";
    protected String basePackage = "org.openapitools";
    protected boolean controllerOnly = false;
    protected boolean useInterfaces = true;
    protected boolean useBeanValidation = true;
    protected boolean handleExceptions = true;
    protected boolean wrapCalls = true;
    protected boolean useSwaggerUI = true;
    protected boolean supportAsync = false;

    public JavaPlayFrameworkCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.outputFolder = "generated-code/javaPlayFramework";
        this.apiTestTemplateFiles.clear();
        this.templateDir = "JavaPlayFramework";
        this.embeddedTemplateDir = "JavaPlayFramework";
        this.apiPackage = "controllers";
        this.modelPackage = "apimodels";
        this.invokerPackage = "org.openapitools.api";
        this.artifactId = "openapi-java-playframework";
        this.projectFolder = "";
        this.sourceFolder = this.projectFolder + "/app";
        this.testFolder = this.projectTestFolder = this.projectFolder + "/test";
        this.updateOption("sourceFolder", this.getSourceFolder());
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.additionalProperties.put("java8", true);
        this.additionalProperties.put("jackson", "true");
        this.cliOptions.add(new CliOption(TITLE, "server title name or client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code").defaultValue(this.getConfigPackage()));
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "base package for generated code").defaultValue(this.getBasePackage()));
        this.cliOptions.add(this.createBooleanCliWithDefault(CONTROLLER_ONLY, "Whether to generate only API interface stubs without the server files.", this.controllerOnly));
        this.cliOptions.add(this.createBooleanCliWithDefault("useBeanValidation", "Use BeanValidation API annotations", this.useBeanValidation));
        this.cliOptions.add(this.createBooleanCliWithDefault(USE_INTERFACES, "Makes the controllerImp implements an interface to facilitate automatic completion when updating from version x to y of your spec", this.useInterfaces));
        this.cliOptions.add(this.createBooleanCliWithDefault(HANDLE_EXCEPTIONS, "Add a 'throw exception' to each controller function. Add also a custom error handler where you can put your custom logic", this.handleExceptions));
        this.cliOptions.add(this.createBooleanCliWithDefault(WRAP_CALLS, "Add a wrapper to each controller function to handle things like metrics, response modification, etc..", this.wrapCalls));
        this.cliOptions.add(this.createBooleanCliWithDefault(USE_SWAGGER_UI, "Add a route to /api which show your documentation in swagger-ui. Will also import needed dependencies", this.useSwaggerUI));
        this.cliOptions.add(this.createBooleanCliWithDefault(SUPPORT_ASYNC, "Support Async operations", this.supportAsync));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-play-framework";
    }

    @Override
    public String getHelp() {
        return "Generates a Java Play Framework Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey(TITLE)) {
            this.setTitle((String)this.additionalProperties.get(TITLE));
        }
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        } else {
            this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        }
        if (this.additionalProperties.containsKey(CONTROLLER_ONLY)) {
            this.setControllerOnly(this.convertPropertyToBoolean(CONTROLLER_ONLY));
        }
        this.writePropertyBack(CONTROLLER_ONLY, this.controllerOnly);
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey(USE_INTERFACES)) {
            this.setUseInterfaces(this.convertPropertyToBoolean(USE_INTERFACES));
        }
        this.writePropertyBack(USE_INTERFACES, this.useInterfaces);
        if (this.additionalProperties.containsKey(HANDLE_EXCEPTIONS)) {
            this.setHandleExceptions(this.convertPropertyToBoolean(HANDLE_EXCEPTIONS));
        }
        this.writePropertyBack(HANDLE_EXCEPTIONS, this.handleExceptions);
        if (this.additionalProperties.containsKey(WRAP_CALLS)) {
            this.setWrapCalls(this.convertPropertyToBoolean(WRAP_CALLS));
        }
        this.writePropertyBack(WRAP_CALLS, this.wrapCalls);
        if (this.additionalProperties.containsKey(USE_SWAGGER_UI)) {
            this.setUseSwaggerUI(this.convertPropertyToBoolean(USE_SWAGGER_UI));
        }
        this.writePropertyBack(USE_SWAGGER_UI, this.useSwaggerUI);
        if (this.additionalProperties.containsKey(SUPPORT_ASYNC)) {
            this.setSupportAsync(this.convertPropertyToBoolean(SUPPORT_ASYNC));
        }
        this.writePropertyBack(SUPPORT_ASYNC, this.supportAsync);
        this.importMapping.remove("ApiModelProperty");
        this.importMapping.remove("ApiModel");
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README"));
        this.supportingFiles.add(new SupportingFile("LICENSE.mustache", "", "LICENSE"));
        this.supportingFiles.add(new SupportingFile("build.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("buildproperties.mustache", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("plugins.mustache", "project", "plugins.sbt"));
        this.supportingFiles.add(new SupportingFile("logback.mustache", "conf", "logback.xml"));
        this.supportingFiles.add(new SupportingFile("application.mustache", "conf", "application.conf"));
        this.supportingFiles.add(new SupportingFile("routes.mustache", "conf", "routes"));
        if (!this.controllerOnly && this.useInterfaces) {
            this.supportingFiles.add(new SupportingFile("module.mustache", "app", "Module.java"));
        }
        this.supportingFiles.add(new SupportingFile("openapiUtils.mustache", "app/openapitools", "OpenAPIUtils.java"));
        this.supportingFiles.add(new SupportingFile("securityApiUtils.mustache", "app/openapitools", "SecurityAPIUtils.java"));
        if (this.handleExceptions) {
            this.supportingFiles.add(new SupportingFile("errorHandler.mustache", "app/openapitools", "ErrorHandler.java"));
        }
        if (this.wrapCalls) {
            this.supportingFiles.add(new SupportingFile("apiCall.mustache", "app/openapitools", "ApiCall.java"));
        }
        if (this.useSwaggerUI) {
            this.supportingFiles.add(new SupportingFile("openapi.mustache", "public", "openapi.json"));
            this.supportingFiles.add(new SupportingFile("apiDocController.mustache", String.format(Locale.ROOT, "app/%s", this.apiPackage.replace(".", File.separator)), "ApiDocController.java"));
        }
        this.apiTemplateFiles.remove("api.mustache");
        this.apiTemplateFiles.put("newApiController.mustache", "Controller.java");
        if (!this.controllerOnly) {
            this.apiTemplateFiles.put("newApi.mustache", "ControllerImp.java");
            if (this.useInterfaces) {
                this.apiTemplateFiles.put("newApiInterface.mustache", "ControllerImpInterface.java");
            }
        }
        this.additionalProperties.put("javaVersion", "1.8");
        this.additionalProperties.put("jdk8", "true");
        this.typeMapping.put("date", "LocalDate");
        this.typeMapping.put("DateTime", "OffsetDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("InputStream", "java.io.InputStream");
        this.typeMapping.put("file", "InputStream");
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("ApiModelProperty");
        model.imports.remove("ApiModel");
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        if (codegenModel.description != null) {
            codegenModel.imports.remove("ApiModel");
        }
        return codegenModel;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getConfigPackage() {
        return this.configPackage;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setControllerOnly(boolean controllerOnly) {
        this.controllerOnly = controllerOnly;
    }

    public void setUseInterfaces(boolean useInterfaces) {
        this.useInterfaces = useInterfaces;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public void setHandleExceptions(boolean handleExceptions) {
        this.handleExceptions = handleExceptions;
    }

    public void setWrapCalls(boolean wrapCalls) {
        this.wrapCalls = wrapCalls;
    }

    public void setUseSwaggerUI(boolean useSwaggerUI) {
        this.useSwaggerUI = useSwaggerUI;
    }

    @Override
    public void setSupportAsync(boolean supportAsync) {
        this.supportAsync = supportAsync;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                for (CodegenParameter param : operation.allParams) {
                    if (!param.isFormParam || !param.isFile) continue;
                    param.dataType = "Http.MultipartFormData.FilePart<TemporaryFile>";
                }
                for (CodegenParameter param : operation.formParams) {
                    if (!param.isFile) continue;
                    param.dataType = "Http.MultipartFormData.FilePart<TemporaryFile>";
                }
                Pattern pathVariableMatcher = Pattern.compile("\\{([^}]+)}");
                Matcher match = pathVariableMatcher.matcher(operation.path);
                while (match.find()) {
                    String completeMatch = match.group();
                    String replacement = ":" + StringUtils.camelize(match.group(1), true);
                    operation.path = operation.path.replace(completeMatch, replacement);
                }
                if (operation.returnType == null) continue;
                if (operation.returnType.equals("Boolean")) {
                    operation.vendorExtensions.put("x-missing-return-info-if-needed", "true");
                }
                if (operation.returnType.equals("BigDecimal")) {
                    operation.vendorExtensions.put("x-missing-return-info-if-needed", "1.0");
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    int end2 = rt.lastIndexOf(">");
                    if (end2 <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end2).trim();
                    operation.returnTypeIsPrimitive = this.languageSpecificPrimitives().contains(operation.returnType) || operation.returnType == null;
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    int end3 = rt.lastIndexOf(">");
                    if (end3 <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end3).split(",")[1].trim();
                    operation.returnTypeIsPrimitive = this.languageSpecificPrimitives().contains(operation.returnType) || operation.returnType == null;
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end).trim();
                operation.returnTypeIsPrimitive = this.languageSpecificPrimitives().contains(operation.returnType) || operation.returnType == null;
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    private CliOption createBooleanCliWithDefault(String optionName, String description, boolean defaultValue) {
        CliOption defaultOption = CliOption.newBoolean(optionName, description);
        defaultOption.setDefault(Boolean.toString(defaultValue));
        return defaultOption;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateJSONSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        List<CodegenSecurity> securities = super.fromSecurity(securitySchemeMap);
        ArrayList<CodegenSecurity> extendedSecurities = new ArrayList<CodegenSecurity>();
        for (CodegenSecurity codegenSecurity : securities) {
            Object tokenIntrospectUrl;
            ExtendedCodegenSecurity extendedCodegenSecurity = new ExtendedCodegenSecurity(codegenSecurity);
            Object jwksUrl = extendedCodegenSecurity.vendorExtensions.get(X_JWKS_URL);
            if (jwksUrl instanceof String) {
                extendedCodegenSecurity.jwksUrl = (String)jwksUrl;
            }
            if ((tokenIntrospectUrl = extendedCodegenSecurity.vendorExtensions.get(X_TOKEN_INTROSPECT_URL)) instanceof String) {
                extendedCodegenSecurity.tokenIntrospectUrl = (String)tokenIntrospectUrl;
            }
            extendedSecurities.add(extendedCodegenSecurity);
        }
        return extendedSecurities;
    }

    class ExtendedCodegenSecurity
    extends CodegenSecurity {
        public String jwksUrl;
        public String tokenIntrospectUrl;

        public ExtendedCodegenSecurity(CodegenSecurity cm) {
            this.name = cm.name;
            this.type = cm.type;
            this.scheme = cm.scheme;
            this.isBasic = cm.isBasic;
            this.isOAuth = cm.isOAuth;
            this.isApiKey = cm.isApiKey;
            this.isBasicBasic = cm.isBasicBasic;
            this.isBasicBearer = cm.isBasicBearer;
            this.isHttpSignature = cm.isHttpSignature;
            this.bearerFormat = cm.bearerFormat;
            this.vendorExtensions = new HashMap<String, Object>(cm.vendorExtensions);
            this.keyParamName = cm.keyParamName;
            this.isKeyInQuery = cm.isKeyInQuery;
            this.isKeyInHeader = cm.isKeyInHeader;
            this.isKeyInCookie = cm.isKeyInCookie;
            this.flow = cm.flow;
            this.authorizationUrl = cm.authorizationUrl;
            this.tokenUrl = cm.tokenUrl;
            this.refreshUrl = cm.refreshUrl;
            this.scopes = cm.scopes;
            this.isCode = cm.isCode;
            this.isPassword = cm.isPassword;
            this.isApplication = cm.isApplication;
            this.isImplicit = cm.isImplicit;
        }

        @Override
        public CodegenSecurity filterByScopeNames(List<String> filterScopes) {
            CodegenSecurity codegenSecurity = super.filterByScopeNames(filterScopes);
            ExtendedCodegenSecurity extendedCodegenSecurity = new ExtendedCodegenSecurity(codegenSecurity);
            extendedCodegenSecurity.jwksUrl = this.jwksUrl;
            extendedCodegenSecurity.tokenIntrospectUrl = this.tokenIntrospectUrl;
            return extendedCodegenSecurity;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            boolean result = super.equals(o);
            ExtendedCodegenSecurity that = (ExtendedCodegenSecurity)o;
            return result && Objects.equals(this.jwksUrl, that.jwksUrl) && Objects.equals(this.tokenIntrospectUrl, that.tokenIntrospectUrl);
        }

        @Override
        public int hashCode() {
            int superHash = super.hashCode();
            return Objects.hash(superHash, this.tokenIntrospectUrl, this.jwksUrl);
        }

        @Override
        public String toString() {
            String superString = super.toString();
            StringBuilder sb = new StringBuilder(superString);
            sb.append(", jwksUrl='").append(this.jwksUrl).append('\'');
            sb.append(", tokenIntrospectUrl='").append(this.tokenIntrospectUrl).append('\'');
            return sb.toString();
        }
    }
}

