/*
 * Decompiled with CFR 0.152.
 */
package org.xlcloud.ssh;

import com.jcraft.jsch.JSchException;
import java.io.File;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.xlcloud.ssh.SCPTask;
import org.xlcloud.ssh.SshCommandExecutor;
import org.xlcloud.ssh.SshExecutionCommand;
import org.xlcloud.ssh.SshExecutionOutput;
import org.xlcloud.ssh.SshSessionFactory;
import org.xlcloud.ssh.exception.SSHException;

public class SCPExecutor {
    private static final Logger LOG = Logger.getLogger(SshCommandExecutor.class);
    @Inject
    private SshSessionFactory sessionFactory;
    @Inject
    SshCommandExecutor commandExecutor;

    public SshExecutionOutput scp(File fileFrom, String destination) throws SSHException {
        final String path = "/" + FilenameUtils.getPath((String)destination);
        try {
            this.commandExecutor.execute(new SshExecutionCommand(){

                @Override
                public String printParams() {
                    return "";
                }

                @Override
                public String getUsername() {
                    return null;
                }

                @Override
                public String getScriptName() {
                    return "mkdir -p " + path;
                }
            });
        }
        catch (JSchException e) {
            LOG.error((Object)("Could not create destination path: " + destination), (Throwable)e);
            throw new SSHException("Could not SCP file to destination", e);
        }
        LOG.info((Object)("executing SCP to destination: " + destination));
        SCPTask scpTask = new SCPTask(fileFrom, destination);
        scpTask.setSessionFactory(this.sessionFactory);
        scpTask.run();
        return scpTask.getExecutionOutput();
    }
}

