/*
 * Decompiled with CFR 0.152.
 */
package org.xlcloud.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.xlcloud.ssh.SshExecutionOutput;
import org.xlcloud.ssh.SshSessionFactory;
import org.xlcloud.ssh.exception.SSHException;

public class SCPTask {
    private static final Logger LOG = Logger.getLogger(SCPTask.class);
    private static final String SCP_COMMAND = "scp -t ";
    private static final byte[] ACK = new byte[]{0};
    private SshSessionFactory sessionFactory;
    private File fileFrom;
    private String desitnation;
    private SshExecutionOutput executionOutput;
    private Channel channel;

    public SCPTask(File file, String desitnation) {
        this.fileFrom = file;
        this.desitnation = desitnation;
        this.executionOutput = new SshExecutionOutput();
    }

    public void run() throws SSHException {
        Session session = null;
        String command = SCP_COMMAND + this.desitnation;
        try {
            session = this.sessionFactory.getSession();
            if (session == null) {
                throw new RuntimeException("could not retreive ssh session");
            }
            this.channel = session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing command: " + command));
            }
            InputStream channelInputStream = this.channel.getInputStream();
            OutputStream channelOutputStream = this.channel.getOutputStream();
            this.channel.connect();
            this.sendFileToRemote(channelInputStream, channelOutputStream);
            this.executionOutput.setExitCode("0");
        }
        catch (Exception e) {
            throw new SSHException("Error during SCP file", e);
        }
        finally {
            if (this.channel != null) {
                this.channel.disconnect();
            }
            if (session != null) {
                this.sessionFactory.returnSession(session);
            }
        }
    }

    private void sendFileToRemote(InputStream in, OutputStream out) throws SSHException {
        long filesize = this.fileFrom.length();
        String command = "C0644 " + filesize + " ";
        command = command + FilenameUtils.getName((String)this.desitnation);
        command = command + "\n";
        try {
            out.write(command.getBytes());
            out.flush();
            this.waitForAck(in);
            IOUtils.copy((InputStream)new FileInputStream(this.fileFrom), (OutputStream)out);
            this.sendAck(out);
            this.waitForAck(in);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during scp file", (Throwable)e);
            throw new SSHException("Error during scp file", e);
        }
    }

    private void sendAck(OutputStream out) throws IOException {
        out.write(ACK);
        out.flush();
    }

    private void waitForAck(InputStream in) throws SSHException {
        try {
            int b = in.read();
            if (b == -1) {
                throw new SSHException("No response from server");
            }
            if (b != 0) {
                StringBuilder sb = new StringBuilder();
                int c = in.read();
                while (c > 0 && c != 10) {
                    sb.append((char)c);
                    c = in.read();
                }
                if (b == 1) {
                    throw new SSHException("server indicated an error: " + sb.toString());
                }
                if (b == 2) {
                    throw new SSHException("server indicated a fatal error: " + sb.toString());
                }
                throw new SSHException("unknown response, code " + b + " message: " + sb.toString());
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Could not read response from server", (Throwable)e);
            throw new SSHException("Could not read response from server", e);
        }
    }

    public SshSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SshSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SshExecutionOutput getExecutionOutput() {
        return this.executionOutput;
    }
}

