/*
 * Decompiled with CFR 0.152.
 */
package org.xlcloud.ssh;

import com.jcraft.jsch.Session;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.xlcloud.ssh.Builder;
import org.xlcloud.ssh.SshSessionFactory;

@ApplicationScoped
public class SshPoolableSessionFactory
implements SshSessionFactory {
    private static final Logger LOG = Logger.getLogger(SshPoolableSessionFactory.class);
    @Inject
    private Builder<Session> sessionBuilder;
    private ObjectPool sessionPool;
    private int maxActive = 10;

    @PostConstruct
    public void init() {
        GenericObjectPool genericPool = new GenericObjectPool((PoolableObjectFactory)new SshSessionPoolableObjectFactory());
        genericPool.setWhenExhaustedAction((byte)2);
        genericPool.setTestOnBorrow(true);
        genericPool.setMaxActive(this.maxActive);
        this.sessionPool = genericPool;
    }

    @Override
    public Session getSession() {
        return this.borrowSession(this.sessionPool);
    }

    @Override
    public void returnSession(Session session) {
        this.returnSession(session, this.sessionPool);
    }

    private Session borrowSession(ObjectPool pool) {
        try {
            return (Session)pool.borrowObject();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not borrow SSH session from pool", (Throwable)e);
            return null;
        }
    }

    private void returnSession(Session session, ObjectPool pool) {
        try {
            pool.returnObject((Object)session);
        }
        catch (Exception e) {
            String host = "unknown";
            if (session != null) {
                host = session.getHost();
            }
            LOG.error((Object)("Could not return SSH session from pool for cluster: " + host), (Throwable)e);
        }
    }

    private class SshSessionPoolableObjectFactory
    implements PoolableObjectFactory {
        private SshSessionPoolableObjectFactory() {
        }

        public Object makeObject() throws Exception {
            Session session = (Session)SshPoolableSessionFactory.this.sessionBuilder.build();
            session.connect();
            return session;
        }

        public void destroyObject(Object obj) throws Exception {
            Session session = (Session)obj;
            if (session.isConnected()) {
                session.disconnect();
            }
        }

        public boolean validateObject(Object obj) {
            Session session = (Session)obj;
            return session.isConnected();
        }

        public void activateObject(Object obj) {
        }

        public void passivateObject(Object obj) {
        }
    }
}

