/*
 * Decompiled with CFR 0.152.
 */
package org.xlcloud.ssh.alternatives;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xlcloud.config.ConfigParam;
import org.xlcloud.logging.LoggingUtils;
import org.xlcloud.ssh.Builder;
import org.xlcloud.ssh.ConfiguredJSch;
import org.xlcloud.ssh.alternatives.AbstractAuthJsch;

public class PasswordAuthJsch
extends AbstractAuthJsch
implements ConfiguredJSch {
    private static final Logger LOG = Logger.getLogger(PasswordAuthJsch.class);
    @Inject
    @ConfigParam
    private String password;

    public void initialize() {
        block7: {
            if (this.jsch == null) {
                try {
                    this.jsch = new JSch();
                    if (StringUtils.isBlank((String)this.username)) {
                        throw new IllegalArgumentException("ssh configuration is not correct. username missing");
                    }
                    if (StringUtils.isBlank((String)this.password)) {
                        throw new IllegalArgumentException("ssh configuration is not correct. password missing");
                    }
                    if (StringUtils.isNotBlank((String)this.knownHosts) && new File(this.knownHosts).exists()) {
                        this.jsch.setKnownHosts(this.knownHosts);
                    }
                    if (this.port == null || this.port <= 0) {
                        throw new IllegalArgumentException("ssh configuration is not correct. port missing or has non-positive value");
                    }
                    break block7;
                }
                catch (JSchException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            LOG.info((Object)"initialization is no needed, skipping");
        }
    }

    @Override
    public Builder<Session> getJschSessionBuilder() {
        this.initialize();
        return new Builder<Session>(){

            @Override
            public Session build() {
                Session session;
                LOG.debug((Object)("building ssh session with configuration: PasswordAuthJsch [password='" + LoggingUtils.mask((String)PasswordAuthJsch.this.password) + "', username='" + PasswordAuthJsch.this.username + "', hostIp='" + PasswordAuthJsch.this.hostIp + "']"));
                try {
                    session = PasswordAuthJsch.this.jsch.getSession(PasswordAuthJsch.this.username, PasswordAuthJsch.this.hostIp, PasswordAuthJsch.this.port.intValue());
                }
                catch (JSchException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                session.setPassword(PasswordAuthJsch.this.password);
                session.setConfig("StrictHostKeyChecking", "no");
                return session;
            }
        };
    }

    public String toString() {
        return "PasswordAuthJsch [password='" + LoggingUtils.mask((String)this.password) + "', username='" + this.username + "', hostIp='" + this.hostIp + "']";
    }
}

