/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.pushingpixels.lafwidget.ant.AugmentException;
import org.pushingpixels.lafwidget.ant.ContainerGhostingType;
import org.pushingpixels.lafwidget.ant.InfoClassVisitor;
import org.pushingpixels.lafwidget.ant.Utils;

public class ContainerGhostingAugmenter {
    private boolean isVerbose;

    protected synchronized void augmentClass(String dir, String name, boolean toInjectAfterOriginal) {
        block43: {
            byte[] b;
            if (this.isVerbose) {
                System.out.println("Working on " + name + ".update() [" + (toInjectAfterOriginal ? "after]" : "before]"));
            }
            String resource = String.valueOf(dir) + File.separator + name.replace('.', '/') + ".class";
            Method methodToAugment = null;
            try {
                URLClassLoader cl = new URLClassLoader(new URL[]{new File(dir).toURL()}, ContainerGhostingAugmenter.class.getClassLoader());
                Class<?> clazz = cl.loadClass(name);
                while (clazz != null) {
                    if (methodToAugment == null) {
                        Method[] methods = clazz.getDeclaredMethods();
                        int i = 0;
                        while (i < methods.length) {
                            Method method = methods[i];
                            if ("update".equals(method.getName())) {
                                methodToAugment = method;
                                break;
                            }
                            ++i;
                        }
                        clazz = clazz.getSuperclass();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new AugmentException(name, e);
            }
            Set<String> existingMethods = null;
            Set<String> existingFields = null;
            InputStream is = null;
            try {
                try {
                    is = new FileInputStream(resource);
                    ClassReader cr = new ClassReader(is);
                    InfoClassVisitor infoAdapter = new InfoClassVisitor();
                    cr.accept(infoAdapter, false);
                    existingMethods = infoAdapter.getMethods();
                    existingFields = infoAdapter.getFields();
                }
                catch (Exception e) {
                    throw new AugmentException(name, e);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (existingFields.contains("containerGhostingMarker")) {
                if (this.isVerbose) {
                    System.out.println("Not augmenting resource, field 'containerGhostingMarker' is present");
                }
                return;
            }
            try {
                try {
                    is = new FileInputStream(resource);
                    ClassReader cr = new ClassReader(is);
                    ClassWriter cw = new ClassWriter(false);
                    AugmentClassAdapter cv = new AugmentClassAdapter(cw, existingMethods, existingFields, methodToAugment, toInjectAfterOriginal);
                    cr.accept(cv, false);
                    b = cw.toByteArray();
                }
                catch (Exception e) {
                    throw new AugmentException(name, e);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(resource);
                    fos.write(b);
                    if (this.isVerbose) {
                        System.out.println("Updated resource " + resource);
                    }
                }
                catch (Exception exception) {
                    if (fos == null) break block43;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void process(String toStrip, File file, List<ContainerGhostingType> ids) throws AugmentException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.process(toStrip, children[i], ids);
                ++i;
            }
        } else {
            String currClassName = file.getAbsolutePath().substring(toStrip.length() + 1);
            currClassName = currClassName.replace(File.separatorChar, '.');
            currClassName = currClassName.substring(0, currClassName.length() - 6);
            for (ContainerGhostingType igt : ids) {
                if (!currClassName.equals(igt.getClassName())) continue;
                this.augmentClass(toStrip, igt.getClassName(), igt.isToInjectAfterOriginal());
            }
        }
    }

    public void setVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public static void main(String[] args) throws AugmentException {
        if (args.length == 0) {
            System.out.println("Usage : java ... IconGhostingDelegateAugmenter [-verbose] [-pattern class_pattern] file_resource");
            System.out.println("\tIf -verbose option is specified, the augmenter prints out its actions.");
            System.out.println("\tIf -class option if specified, its value is used as class name to augment.");
            System.out.println("\tIf -before option if specified, the code is injected before the original code.");
            System.out.println("\tThe last parameter can point to either a file or a directory. The directory should be the root directory for classes.");
            return;
        }
        ContainerGhostingAugmenter uiDelegateAugmenter = new ContainerGhostingAugmenter();
        int argNum = 0;
        String className = null;
        boolean isAfter = true;
        while (true) {
            String currArg;
            if ("-verbose".equals(currArg = args[argNum])) {
                uiDelegateAugmenter.setVerbose(true);
                ++argNum;
                continue;
            }
            if ("-class".equals(currArg)) {
                className = args[++argNum];
                ++argNum;
                continue;
            }
            if (!"-before".equals(currArg)) break;
            ++argNum;
            isAfter = false;
        }
        File starter = new File(args[argNum]);
        ContainerGhostingType igt = new ContainerGhostingType();
        igt.setClassName(className);
        igt.setToInjectAfterOriginal(isAfter);
        uiDelegateAugmenter.process(starter.getAbsolutePath(), starter, Arrays.asList(igt));
    }

    protected class AugmentClassAdapter
    extends ClassAdapter
    implements Opcodes {
        private Set<String> existingMethods;
        private Set<String> existingFields;
        private Method methodToAugment;
        private boolean toInjectAfterOriginal;
        private String prefix;

        public AugmentClassAdapter(ClassVisitor cv, Set<String> existingMethods, Set<String> existingFields, Method methodToAugment, boolean toInjectAfterOriginal) {
            super(cv);
            this.existingMethods = existingMethods;
            this.existingFields = existingFields;
            this.methodToAugment = methodToAugment;
            this.toInjectAfterOriginal = toInjectAfterOriginal;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.prefix = "__" + name.replaceAll("/", "__") + "__container__";
            super.visit(version, access, name, signature, superName, interfaces);
            if (!this.existingFields.contains("containerGhostingMarker")) {
                FieldVisitor fv = this.visitField(4, "containerGhostingMarker", "Z", null, null);
                fv.visitEnd();
            }
            String methodName = this.methodToAugment.getName();
            boolean hasOriginal = this.existingMethods.contains(methodName);
            boolean hasDelegate = this.existingMethods.contains(String.valueOf(this.prefix) + methodName);
            String methodSignature = Utils.getMethodDesc(this.methodToAugment);
            int paramCount = this.methodToAugment.getParameterTypes().length;
            if (ContainerGhostingAugmenter.this.isVerbose) {
                System.out.println("... Augmenting " + methodName + " " + methodSignature + " : original - " + hasOriginal + ", delegate - " + hasDelegate + ", " + paramCount + " params");
            }
            if (!hasDelegate) {
                if (this.toInjectAfterOriginal) {
                    this.augmentUpdateMethodAfter(!hasOriginal, name, superName, methodSignature);
                } else {
                    this.augmentUpdateMethodBefore(!hasOriginal, name, superName, methodSignature);
                }
            }
        }

        public void augmentUpdateMethodBefore(boolean toSynthOriginal, String className, String superClassName, String methodDesc) {
            MethodVisitor mv;
            if (toSynthOriginal) {
                mv = this.cv.visitMethod(1, String.valueOf(this.prefix) + "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, superClassName, "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V");
                mv.visitInsn(177);
                mv.visitMaxs(3, 3);
                mv.visitEnd();
            }
            mv = this.cv.visitMethod(4, "update", methodDesc, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/pushingpixels/lafwidget/animation/effects/GhostPaintingUtils", "paintGhostImages", "(Ljava/awt/Component;Ljava/awt/Graphics;)V");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, className, String.valueOf(this.prefix) + "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V");
            mv.visitInsn(177);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
        }

        public void augmentUpdateMethodAfter(boolean toSynthOriginal, String className, String superClassName, String methodDesc) {
            MethodVisitor mv;
            if (toSynthOriginal) {
                mv = this.cv.visitMethod(1, String.valueOf(this.prefix) + "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, superClassName, "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V");
                mv.visitInsn(177);
                mv.visitMaxs(3, 3);
                mv.visitEnd();
            }
            mv = this.cv.visitMethod(4, "update", methodDesc, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, className, String.valueOf(this.prefix) + "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V");
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/pushingpixels/lafwidget/animation/effects/GhostPaintingUtils", "paintGhostImages", "(Ljava/awt/Component;Ljava/awt/Graphics;)V");
            mv.visitInsn(177);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.methodToAugment.getName().equals(name) && !this.existingMethods.contains(String.valueOf(this.prefix) + name)) {
                if (ContainerGhostingAugmenter.this.isVerbose) {
                    System.out.println("... renaming '" + name + "(" + desc + ")' to '" + this.prefix + name + "'");
                }
                return this.cv.visitMethod(access, String.valueOf(this.prefix) + name, desc, signature, exceptions);
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

