/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.lafwidget.ant.AugmentException;

public class Utils {
    protected Map<String, String> lafMap = new HashMap<String, String>();
    protected static Utils instance = new Utils();
    public static final String[] UI_IDS = new String[]{"ButtonUI", "CheckBoxUI", "CheckBoxMenuItemUI", "ColorChooserUI", "ComboBoxUI", "DesktopIconUI", "DesktopPaneUI", "EditorPaneUI", "FormattedTextFieldUI", "InternalFrameUI", "LabelUI", "ListUI", "MenuUI", "MenuBarUI", "MenuItemUI", "OptionPaneUI", "PanelUI", "PasswordFieldUI", "PopupMenuUI", "PopupMenuSeparatorUI", "ProgressBarUI", "RadioButtonUI", "RadioButtonMenuItemUI", "RootPaneUI", "ScrollBarUI", "ScrollPaneUI", "SplitPaneUI", "SliderUI", "SeparatorUI", "SpinnerUI", "ToolBarSeparatorUI", "TabbedPaneUI", "TableUI", "TableHeaderUI", "TextAreaUI", "TextFieldUI", "TextPaneUI", "ToggleButtonUI", "ToolBarUI", "ToolTipUI", "TreeUI", "ViewportUI"};

    private Utils() {
        this.lafMap.put(BasicLookAndFeel.class.getName(), "javax.swing.plaf.basic.Basic");
        this.lafMap.put(MetalLookAndFeel.class.getName(), "javax.swing.plaf.metal.Metal");
    }

    public static Utils getUtils() {
        return instance;
    }

    public String getUIDelegate(String uiKey, String lafClassName) {
        try {
            lafClassName = lafClassName.replace('/', '.');
            return this.getUIDelegate(uiKey, Class.forName(lafClassName));
        }
        catch (ClassNotFoundException cnfe) {
            throw new AugmentException("Class '" + lafClassName + "' not found", cnfe);
        }
    }

    public String getUIDelegate(String uiKey, Class<?> origLafClazz) {
        Class<?> lafClazz = origLafClazz;
        while (lafClazz != null) {
            String prefix = this.lafMap.get(lafClazz.getName());
            if (prefix != null) {
                String fullClassName = String.valueOf(prefix) + uiKey;
                Class<?> delegateClazz = null;
                try {
                    delegateClazz = Class.forName(fullClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (delegateClazz != null) {
                    return fullClassName;
                }
            }
            lafClazz = lafClazz.getSuperclass();
        }
        throw new AugmentException("No match for '" + uiKey + "' in '" + origLafClazz.getName() + "' hierarchy");
    }

    public static String getTypeDesc(Class<?> clazz) {
        if (clazz.isArray()) {
            return "[" + Utils.getTypeDesc(clazz.getComponentType());
        }
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public static String getMethodDesc(Method method) {
        StringBuffer result = new StringBuffer();
        result.append("(");
        Class<?>[] paramClasses = method.getParameterTypes();
        int i = 0;
        while (i < paramClasses.length) {
            Class<?> paramClass = paramClasses[i];
            result.append(Utils.getTypeDesc(paramClass));
            ++i;
        }
        result.append(")");
        result.append(Utils.getTypeDesc(method.getReturnType()));
        return result.toString();
    }

    public static void main(String[] args) {
        for (Map.Entry<String, String> entry : Utils.instance.lafMap.entrySet()) {
            String lafClassName = entry.getKey();
            System.out.println(lafClassName);
            String prefix = entry.getValue();
            int i = 0;
            while (i < UI_IDS.length) {
                String uiClassName = String.valueOf(prefix) + UI_IDS[i];
                try {
                    Class<?> uiClazz = Class.forName(uiClassName);
                    System.out.println("\t" + UI_IDS[i]);
                    Constructor<?>[] ctrs = uiClazz.getDeclaredConstructors();
                    int j = 0;
                    while (j < ctrs.length) {
                        Constructor<?> ctr = ctrs[j];
                        Class<?>[] ctrArgs = ctr.getParameterTypes();
                        System.out.print("\t\t" + ctrArgs.length + " args : ");
                        int k = 0;
                        while (k < ctrArgs.length) {
                            System.out.print(String.valueOf(ctrArgs[k].getName()) + ",");
                            ++k;
                        }
                        System.out.println();
                        ++j;
                    }
                }
                catch (ClassNotFoundException uiClazz) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }
}

