/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonarsource.scanner.maven.DependencyCollector;
import org.sonarsource.scanner.maven.bootstrap.MavenUtils;

public class MavenProjectConverter {
    private final Log log;
    private static final char SEPARATOR = ',';
    private static final String UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE = "Unable to determine structure of project. Probably you use Maven Advanced Reactor Options with a broken tree of modules.";
    private static final String MODULE_KEY = "sonar.moduleKey";
    private static final String PROPERTY_PROJECT_BUILDDIR = "sonar.projectBuildDir";
    private static final String JAVA_SOURCE_PROPERTY = "sonar.java.source";
    private static final String JAVA_TARGET_PROPERTY = "sonar.java.target";
    private static final String LINKS_HOME_PAGE = "sonar.links.homepage";
    private static final String LINKS_CI = "sonar.links.ci";
    private static final String LINKS_ISSUE_TRACKER = "sonar.links.issue";
    private static final String LINKS_SOURCES = "sonar.links.scm";
    private static final String LINKS_SOURCES_DEV = "sonar.links.scm_dev";
    private static final String MAVEN_PACKAGING_POM = "pom";
    private static final String MAVEN_PACKAGING_WAR = "war";
    public static final String ARTIFACTID_MAVEN_WAR_PLUGIN = "maven-war-plugin";
    public static final String ARTIFACTID_MAVEN_SUREFIRE_PLUGIN = "maven-surefire-plugin";
    public static final String ARTIFACTID_FINDBUGS_MAVEN_PLUGIN = "findbugs-maven-plugin";
    public static final String FINDBUGS_EXCLUDE_FILTERS = "sonar.findbugs.excludeFilters";
    private static final String JAVA_PROJECT_MAIN_BINARY_DIRS = "sonar.java.binaries";
    private static final String JAVA_PROJECT_MAIN_LIBRARIES = "sonar.java.libraries";
    private static final String JAVA_PROJECT_TEST_BINARY_DIRS = "sonar.java.test.binaries";
    private static final String JAVA_PROJECT_TEST_LIBRARIES = "sonar.java.test.libraries";
    private static final String SUREFIRE_REPORTS_PATH_PROPERTY = "sonar.junit.reportsPath";
    private static final String PROJECT_BINARY_DIRS = "sonar.binaries";
    private static final String PROJECT_LIBRARIES = "sonar.libraries";
    private Properties userProperties;
    private DependencyCollector dependencyCollector;

    public MavenProjectConverter(Log log, DependencyCollector dependencyCollector) {
        this.log = log;
        this.dependencyCollector = dependencyCollector;
    }

    public Properties configure(List<MavenProject> mavenProjects, MavenProject root, Properties userProperties) throws MojoExecutionException {
        this.userProperties = userProperties;
        HashMap<MavenProject, Properties> propsByModule = new HashMap<MavenProject, Properties>();
        try {
            this.configureModules(mavenProjects, propsByModule);
            Properties props = new Properties();
            props.setProperty("sonar.projectKey", MavenProjectConverter.getSonarKey(root));
            MavenProjectConverter.rebuildModuleHierarchy(props, propsByModule, root, "");
            if (!propsByModule.isEmpty()) {
                throw new IllegalStateException("Unable to determine structure of project. Probably you use Maven Advanced Reactor Options with a broken tree of modules. \"" + ((MavenProject)propsByModule.keySet().iterator().next()).getName() + "\" is orphan");
            }
            return props;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot configure project", e);
        }
    }

    private static void rebuildModuleHierarchy(Properties properties, Map<MavenProject, Properties> propsByModule, MavenProject current, String prefix) throws IOException {
        Properties currentProps = propsByModule.get(current);
        if (currentProps == null) {
            throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
        }
        for (Map.Entry<Object, Object> prop : currentProps.entrySet()) {
            properties.put(prefix + prop.getKey(), prop.getValue());
        }
        propsByModule.remove(current);
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (String modulePathStr : current.getModules()) {
            File modulePath = new File(current.getBasedir(), modulePathStr);
            MavenProject module = MavenProjectConverter.findMavenProject(modulePath, propsByModule.keySet());
            if (module == null) continue;
            String moduleId = module.getGroupId() + ":" + module.getArtifactId();
            MavenProjectConverter.rebuildModuleHierarchy(properties, propsByModule, module, prefix + moduleId + ".");
            moduleIds.add(moduleId);
        }
        if (!moduleIds.isEmpty()) {
            properties.put(prefix + "sonar.modules", StringUtils.join(moduleIds, (char)','));
        }
    }

    private void configureModules(List<MavenProject> mavenProjects, Map<MavenProject, Properties> propsByModule) throws IOException, MojoExecutionException {
        for (MavenProject pom : mavenProjects) {
            boolean skipped = "true".equals(pom.getModel().getProperties().getProperty("sonar.skip"));
            if (skipped) {
                this.log.info((CharSequence)("Module " + pom + " skipped by property 'sonar.skip'"));
                continue;
            }
            Properties props = new Properties();
            this.merge(pom, props);
            propsByModule.put(pom, props);
        }
    }

    private static MavenProject findMavenProject(File modulePath, Collection<MavenProject> modules) throws IOException {
        File canonical = modulePath.getCanonicalFile();
        for (MavenProject module : modules) {
            if (!module.getBasedir().getCanonicalFile().equals(canonical) && !module.getFile().getCanonicalFile().equals(canonical)) continue;
            return module;
        }
        return null;
    }

    @VisibleForTesting
    void merge(MavenProject pom, Properties props) throws MojoExecutionException {
        MavenProjectConverter.defineProjectKey(pom, props);
        props.setProperty("sonar.projectVersion", pom.getVersion());
        props.setProperty("sonar.projectName", pom.getName());
        String description = pom.getDescription();
        if (description != null) {
            props.setProperty("sonar.projectDescription", description);
        }
        MavenProjectConverter.guessJavaVersion(pom, props);
        MavenProjectConverter.guessEncoding(pom, props);
        MavenProjectConverter.convertMavenLinksToProperties(props, pom);
        props.setProperty("sonar.maven.projectDependencies", this.dependencyCollector.toJson(pom));
        this.synchronizeFileSystemAndOtherProps(pom, props);
        MavenProjectConverter.findBugsExcludeFileMaven(pom, props);
    }

    private static void defineProjectKey(MavenProject pom, Properties props) {
        String key = pom.getModel().getProperties().containsKey("sonar.projectKey") ? pom.getModel().getProperties().getProperty("sonar.projectKey") : MavenProjectConverter.getSonarKey(pom);
        props.setProperty(MODULE_KEY, key);
    }

    private static String getSonarKey(MavenProject pom) {
        return pom.getGroupId() + ":" + pom.getArtifactId();
    }

    private static void guessEncoding(MavenProject pom, Properties props) {
        String encoding = MavenUtils.getSourceEncoding(pom);
        if (encoding != null) {
            props.setProperty("sonar.sourceEncoding", encoding);
        }
    }

    private static void guessJavaVersion(MavenProject pom, Properties props) {
        String version = MavenUtils.getJavaSourceVersion(pom);
        if (version != null) {
            props.setProperty(JAVA_SOURCE_PROPERTY, version);
        }
        if ((version = MavenUtils.getJavaVersion(pom)) != null) {
            props.setProperty(JAVA_TARGET_PROPERTY, version);
        }
    }

    private static void findBugsExcludeFileMaven(MavenProject pom, Properties props) {
        String excludeFilterFile = MavenUtils.getPluginSetting(pom, "org.codehaus.mojo", ARTIFACTID_FINDBUGS_MAVEN_PLUGIN, "excludeFilterFile", null);
        File path = MavenProjectConverter.resolvePath(excludeFilterFile, pom.getBasedir());
        if (path != null && path.exists()) {
            props.put(FINDBUGS_EXCLUDE_FILTERS, path.getAbsolutePath());
        }
    }

    private static void convertMavenLinksToProperties(Properties props, MavenProject pom) {
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_HOME_PAGE, pom.getUrl());
        Scm scm = pom.getScm();
        if (scm == null) {
            scm = new Scm();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_SOURCES, scm.getUrl());
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_SOURCES_DEV, scm.getDeveloperConnection());
        CiManagement ci = pom.getCiManagement();
        if (ci == null) {
            ci = new CiManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_CI, ci.getUrl());
        IssueManagement issues = pom.getIssueManagement();
        if (issues == null) {
            issues = new IssueManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_ISSUE_TRACKER, issues.getUrl());
    }

    private static void setPropertyIfNotAlreadyExists(Properties props, String propertyKey, String propertyValue) {
        if (StringUtils.isBlank((String)props.getProperty(propertyKey))) {
            props.setProperty(propertyKey, StringUtils.defaultString((String)propertyValue));
        }
    }

    private void synchronizeFileSystemAndOtherProps(MavenProject pom, Properties props) throws MojoExecutionException {
        props.setProperty("sonar.projectBaseDir", pom.getBasedir().getAbsolutePath());
        File buildDir = MavenProjectConverter.getBuildDir(pom);
        if (buildDir != null) {
            props.setProperty(PROPERTY_PROJECT_BUILDDIR, buildDir.getAbsolutePath());
            props.setProperty("sonar.working.directory", MavenProjectConverter.getSonarWorkDir(pom).getAbsolutePath());
        }
        MavenProjectConverter.populateBinaries(pom, props);
        MavenProjectConverter.populateLibraries(pom, props, false);
        MavenProjectConverter.populateLibraries(pom, props, true);
        MavenProjectConverter.populateSurefireReportsPath(pom, props);
        props.putAll((Map<?, ?>)pom.getModel().getProperties());
        props.putAll((Map<?, ?>)this.userProperties);
        List<File> mainDirs = this.mainSources(pom);
        props.setProperty("sonar.sources", StringUtils.join((Object[])MavenProjectConverter.toPaths(mainDirs), (char)','));
        List<File> testDirs = this.testSources(pom);
        if (!testDirs.isEmpty()) {
            props.setProperty("sonar.tests", StringUtils.join((Object[])MavenProjectConverter.toPaths(testDirs), (char)','));
        } else {
            props.remove("sonar.tests");
        }
    }

    private static void populateSurefireReportsPath(MavenProject pom, Properties props) {
        String surefireReportsPath = MavenUtils.getPluginSetting(pom, "org.apache.maven.plugins", ARTIFACTID_MAVEN_SUREFIRE_PLUGIN, "reportsDirectory", pom.getBuild().getDirectory() + File.separator + "surefire-reports");
        File path = MavenProjectConverter.resolvePath(surefireReportsPath, pom.getBasedir());
        if (path != null && path.exists()) {
            props.put(SUREFIRE_REPORTS_PATH_PROPERTY, path.getAbsolutePath());
        }
    }

    private static void populateLibraries(MavenProject pom, Properties props, boolean test) throws MojoExecutionException {
        ArrayList libraries = Lists.newArrayList();
        try {
            List classpathElements;
            List list = classpathElements = test ? pom.getTestClasspathElements() : pom.getCompileClasspathElements();
            if (classpathElements != null) {
                for (String classPathString : classpathElements) {
                    File libPath;
                    if (classPathString.equals(test ? pom.getBuild().getTestOutputDirectory() : pom.getBuild().getOutputDirectory()) || (libPath = MavenProjectConverter.resolvePath(classPathString, pom.getBasedir())) == null || !libPath.exists()) continue;
                    libraries.add(libPath);
                }
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to populate" + (test ? " test" : "") + " libraries", (Exception)((Object)e));
        }
        if (!libraries.isEmpty()) {
            String librariesValue = StringUtils.join((Object[])MavenProjectConverter.toPaths(libraries), (char)',');
            if (test) {
                props.setProperty(JAVA_PROJECT_TEST_LIBRARIES, librariesValue);
            } else {
                props.setProperty(PROJECT_LIBRARIES, librariesValue);
                props.setProperty(JAVA_PROJECT_MAIN_LIBRARIES, librariesValue);
            }
        }
    }

    private static void populateBinaries(MavenProject pom, Properties props) {
        File testBinaryDir;
        File mainBinaryDir = MavenProjectConverter.resolvePath(pom.getBuild().getOutputDirectory(), pom.getBasedir());
        if (mainBinaryDir != null && mainBinaryDir.exists()) {
            String binPath = mainBinaryDir.getAbsolutePath();
            props.setProperty(PROJECT_BINARY_DIRS, binPath);
            props.setProperty(JAVA_PROJECT_MAIN_BINARY_DIRS, binPath);
        }
        if ((testBinaryDir = MavenProjectConverter.resolvePath(pom.getBuild().getTestOutputDirectory(), pom.getBasedir())) != null && testBinaryDir.exists()) {
            String binPath = testBinaryDir.getAbsolutePath();
            props.setProperty(JAVA_PROJECT_TEST_BINARY_DIRS, binPath);
        }
    }

    public static File getSonarWorkDir(MavenProject pom) {
        return new File(MavenProjectConverter.getBuildDir(pom), "sonar");
    }

    private static File getBuildDir(MavenProject pom) {
        return MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir());
    }

    static File resolvePath(@Nullable String path, File basedir) {
        if (path != null) {
            File file = new File(StringUtils.trim((String)path));
            if (!file.isAbsolute()) {
                file = new File(basedir, path).getAbsoluteFile();
            }
            return file;
        }
        return null;
    }

    static List<File> resolvePaths(Collection<String> paths, File basedir) {
        ArrayList result = Lists.newArrayList();
        for (String path : paths) {
            File fileOrDir = MavenProjectConverter.resolvePath(path, basedir);
            if (fileOrDir == null) continue;
            result.add(fileOrDir);
        }
        return result;
    }

    private List<File> mainSources(MavenProject pom) throws MojoExecutionException {
        LinkedHashSet<String> sources = new LinkedHashSet<String>();
        if (MAVEN_PACKAGING_WAR.equals(pom.getModel().getPackaging())) {
            sources.add(MavenUtils.getPluginSetting(pom, "org.apache.maven.plugins", ARTIFACTID_MAVEN_WAR_PLUGIN, "warSourceDirectory", "src/main/webapp"));
        }
        sources.add(pom.getFile().getPath());
        sources.addAll(pom.getCompileSourceRoots());
        return this.sourcePaths(pom, "sonar.sources", sources);
    }

    private List<File> testSources(MavenProject pom) throws MojoExecutionException {
        return this.sourcePaths(pom, "sonar.tests", pom.getTestCompileSourceRoots());
    }

    private List<File> sourcePaths(MavenProject pom, String propertyKey, Collection<String> mavenPaths) throws MojoExecutionException {
        List<File> filesOrDirs;
        boolean userDefined = false;
        String prop = StringUtils.defaultIfEmpty((String)this.userProperties.getProperty(propertyKey), (String)pom.getProperties().getProperty(propertyKey));
        if (prop != null) {
            List<String> paths = Arrays.asList(StringUtils.split((String)prop, (String)","));
            filesOrDirs = MavenProjectConverter.resolvePaths(paths, pom.getBasedir());
            userDefined = true;
        } else {
            filesOrDirs = MavenProjectConverter.resolvePaths(mavenPaths, pom.getBasedir());
        }
        if (userDefined && !MAVEN_PACKAGING_POM.equals(pom.getModel().getPackaging())) {
            return MavenProjectConverter.existingPathsOrFail(filesOrDirs, pom, propertyKey);
        }
        return MavenProjectConverter.removeNested(MavenProjectConverter.keepExistingPaths(filesOrDirs));
    }

    private static List<File> existingPathsOrFail(List<File> dirs, MavenProject pom, String propertyKey) throws MojoExecutionException {
        for (File dir : dirs) {
            if (dir.exists()) continue;
            throw new MojoExecutionException(String.format("The directory '%s' does not exist for Maven module %s. Please check the property %s", dir.getAbsolutePath(), pom.getId(), propertyKey));
        }
        return dirs;
    }

    private static List<File> keepExistingPaths(List<File> files) {
        return Lists.newArrayList((Iterable)Collections2.filter(files, (Predicate)new FileExistsFilter()));
    }

    private static List<File> removeNested(List<File> originalPaths) {
        ArrayList<File> result = new ArrayList<File>();
        for (File maybeChild : originalPaths) {
            boolean hasParent = false;
            for (File possibleParent : originalPaths) {
                if (!MavenProjectConverter.isStrictChild(maybeChild, possibleParent)) continue;
                hasParent = true;
            }
            if (hasParent) continue;
            result.add(maybeChild);
        }
        return result;
    }

    static boolean isStrictChild(File maybeChild, File possibleParent) {
        return !maybeChild.equals(possibleParent) && maybeChild.toPath().startsWith(possibleParent.toPath());
    }

    private static String[] toPaths(Collection<File> dirs) {
        Collection paths = Collections2.transform(dirs, (Function)new AbsolutePathTransform());
        return paths.toArray(new String[paths.size()]);
    }

    private static class AbsolutePathTransform
    implements Function<File, String> {
        private AbsolutePathTransform() {
        }

        public String apply(File dir) {
            return dir.getAbsolutePath();
        }
    }

    private static class FileExistsFilter
    implements Predicate<File> {
        private FileExistsFilter() {
        }

        public boolean apply(File fileOrDir) {
            return fileOrDir != null && fileOrDir.exists();
        }
    }
}

