/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.util.ClassUtils;

public abstract class AbstractJavaTypeMapper
implements BeanClassLoaderAware {
    public static final String DEFAULT_CLASSID_FIELD_NAME = "__TypeId__";
    public static final String DEFAULT_CONTENT_CLASSID_FIELD_NAME = "__ContentTypeId__";
    public static final String DEFAULT_KEY_CLASSID_FIELD_NAME = "__KeyTypeId__";
    private final Map<String, Class<?>> idClassMapping = new HashMap();
    private final Map<Class<?>, String> classIdMapping = new HashMap();
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public String getClassIdFieldName() {
        return DEFAULT_CLASSID_FIELD_NAME;
    }

    public String getContentClassIdFieldName() {
        return DEFAULT_CONTENT_CLASSID_FIELD_NAME;
    }

    public String getKeyClassIdFieldName() {
        return DEFAULT_KEY_CLASSID_FIELD_NAME;
    }

    public void setIdClassMapping(Map<String, Class<?>> idClassMapping) {
        this.idClassMapping.putAll(idClassMapping);
        this.createReverseMap();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void addHeader(MessageProperties properties, String headerName, Class<?> clazz) {
        if (this.classIdMapping.containsKey(clazz)) {
            properties.getHeaders().put(headerName, this.classIdMapping.get(clazz));
        } else {
            properties.getHeaders().put(headerName, clazz.getName());
        }
    }

    protected String retrieveHeader(MessageProperties properties, String headerName) {
        String classId = this.retrieveHeaderAsString(properties, headerName);
        if (classId == null) {
            throw new MessageConversionException("failed to convert Message content. Could not resolve " + headerName + " in header");
        }
        return classId;
    }

    protected String retrieveHeaderAsString(MessageProperties properties, String headerName) {
        Map<String, Object> headers = properties.getHeaders();
        Object classIdFieldNameValue = headers.get(headerName);
        String classId = null;
        if (classIdFieldNameValue != null) {
            classId = classIdFieldNameValue.toString();
        }
        return classId;
    }

    private void createReverseMap() {
        this.classIdMapping.clear();
        for (Map.Entry<String, Class<?>> entry : this.idClassMapping.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            this.classIdMapping.put(clazz, id);
        }
    }

    public Map<String, Class<?>> getIdClassMapping() {
        return Collections.unmodifiableMap(this.idClassMapping);
    }

    protected boolean hasInferredTypeHeader(MessageProperties properties) {
        return properties.getInferredArgumentType() != null;
    }

    protected JavaType fromInferredTypeHeader(MessageProperties properties) {
        return TypeFactory.defaultInstance().constructType(properties.getInferredArgumentType());
    }
}

