/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.webbitserver.netty.HybiWebSocketFrameDecoder;

public class EncodingHybiFrame {
    private final int opcode;
    private final boolean fin;
    private final int rsv;
    private byte[] maskingKey;
    private final ChannelBuffer data;

    public EncodingHybiFrame(int opcode, boolean fin, int rsv, byte[] maskingKey, ChannelBuffer fragment) {
        this.opcode = opcode;
        this.fin = fin;
        this.rsv = rsv;
        this.maskingKey = maskingKey;
        this.data = fragment;
    }

    public ChannelBuffer encode() throws TooLongFrameException {
        ChannelBuffer header;
        int b0 = 0;
        if (this.fin) {
            b0 |= 0x80;
        }
        b0 |= this.rsv % 8 << 4;
        b0 |= this.opcode % 128;
        int b1 = this.maskingKey != null ? 128 : 0;
        int headerLength = this.maskingKey != null ? 6 : 2;
        int length = this.data.readableBytes();
        if (this.opcode == 9 && length > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + length);
        }
        if (length <= 125) {
            header = this.createBuffer(headerLength + length);
            header.writeByte(b0);
            header.writeByte(b1 |= length & 0x7F);
        } else if (length <= 65535) {
            header = this.createBuffer((headerLength += 2) + length);
            header.writeByte(b0);
            header.writeByte(b1 |= 0x7E);
            header.writeByte(length >>> 8 & 0xFF);
            header.writeByte(length & 0xFF);
        } else {
            header = this.createBuffer((headerLength += 8) + length);
            header.writeByte(b0);
            header.writeByte(b1 |= 0x7F);
            header.writeLong((long)length);
        }
        if (this.maskingKey != null) {
            header.writeBytes(this.maskingKey);
            HybiWebSocketFrameDecoder.applyMask(this.data, this.maskingKey);
        }
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, this.data});
    }

    private ChannelBuffer createBuffer(int length) {
        return ChannelBuffers.buffer((int)length);
    }
}

