/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import io.agroal.api.transaction.TransactionAware;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.XAResourceWrapper;

public class BaseXAResource
implements XAResourceWrapper {
    private static final String PRODUCT_NAME = BaseXAResource.class.getPackage().getImplementationTitle();
    private static final String PRODUCT_VERSION = BaseXAResource.class.getPackage().getImplementationVersion();
    private final TransactionAware connection;
    private final XAResource xaResource;
    private final String jndiName;

    public BaseXAResource(TransactionAware connection, XAResource xaResource, String jndiName) {
        this.connection = connection;
        this.xaResource = xaResource;
        this.jndiName = jndiName;
    }

    public XAResource getResource() {
        return this.xaResource;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaResource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.xaResource.end(xid, flags);
        try {
            this.connection.transactionEnd();
        }
        catch (Exception t) {
            throw new XAException("Error trying to end xa transaction: " + t.getMessage());
        }
    }

    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        return this.xaResource.isSameRM(xaRes);
    }

    public int prepare(Xid xid) throws XAException {
        return this.xaResource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.xaResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            this.connection.transactionStart();
        }
        catch (Exception t) {
            throw new XAException("Error trying to start xa transaction: " + t.getMessage());
        }
        this.xaResource.start(xid, flags);
    }
}

