/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Map;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.impl.NullAuditLogger;

public class GlobalAuthorizationConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<AuditLogger> AUDIT_LOGGER = AttributeDefinition.builder((String)"auditLogger", (Object)new NullAuditLogger()).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    public static final AttributeDefinition<PrincipalRoleMapper> PRINCIPAL_ROLE_MAPPER = AttributeDefinition.builder((String)"principalRoleMapper", null, PrincipalRoleMapper.class).immutable().build();
    public static final AttributeDefinition<Map> ROLES = AttributeDefinition.builder((String)"roles", null, Map.class).build();
    private final Attribute<Boolean> enabled;
    private final Attribute<AuditLogger> auditLogger;
    private final Attribute<PrincipalRoleMapper> principalRoleMapper;
    private final Attribute<Map> roles;
    private final AttributeSet attributes;

    static final AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalAuthorizationConfiguration.class, new AttributeDefinition[]{ENABLED, AUDIT_LOGGER, PRINCIPAL_ROLE_MAPPER, ROLES});
    }

    public GlobalAuthorizationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.auditLogger = attributes.attribute(AUDIT_LOGGER);
        this.principalRoleMapper = attributes.attribute(PRINCIPAL_ROLE_MAPPER);
        this.roles = attributes.attribute(ROLES);
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public AuditLogger auditLogger() {
        return (AuditLogger)this.auditLogger.get();
    }

    public PrincipalRoleMapper principalRoleMapper() {
        return (PrincipalRoleMapper)this.principalRoleMapper.get();
    }

    public Map<String, Role> roles() {
        return (Map)this.roles.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalAuthorizationConfiguration [attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalAuthorizationConfiguration other = (GlobalAuthorizationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }
}

