/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.ejb.protocol.remote.CallbackBuffer;
import org.jboss.ejb.protocol.remote.EJBServerChannel;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.ListenerHandle;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.util.MessageTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.Assert;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionService;
import org.xnio.IoUtils;

public final class RemoteEJBService {
    private final OpenListener openListener;
    private final CallbackBuffer callbackBuffer = new CallbackBuffer();

    private RemoteEJBService(final Association association, final RemotingTransactionService transactionService) {
        this.openListener = new OpenListener(){

            public void channelOpened(Channel channel) {
                final MessageTracker messageTracker = new MessageTracker(channel, ((Integer)channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES)).intValue());
                channel.receiveMessage(new Channel.Receiver(){

                    public void handleError(Channel channel, IOException error) {
                    }

                    public void handleEnd(Channel channel) {
                    }

                    public void handleMessage(Channel channel, MessageInputStream message) {
                        int version;
                        try {
                            version = Math.min(3, StreamUtils.readInt8((InputStream)message));
                            while (message.read() != -1) {
                                message.skip(Long.MAX_VALUE);
                            }
                        }
                        catch (IOException e) {
                            IoUtils.safeClose((Closeable)channel);
                            return;
                        }
                        EJBServerChannel serverChannel = new EJBServerChannel(transactionService.getServerForConnection(channel.getConnection()), channel, version, messageTracker);
                        RemoteEJBService.this.callbackBuffer.addListener((sc, a) -> {
                            ListenerHandle handle1 = a.registerClusterTopologyListener(sc.createTopologyListener());
                            ListenerHandle handle2 = a.registerModuleAvailabilityListener(sc.createModuleListener());
                            channel.receiveMessage(sc.getReceiver((Association)a, handle1, handle2));
                        }, serverChannel, association);
                    }
                });
                try (MessageOutputStream mos = messageTracker.openMessage();){
                    mos.writeByte(3);
                    StreamUtils.writePackedUnsignedInt31((OutputStream)mos, (int)1);
                    mos.writeUTF("river");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    IoUtils.safeClose((Closeable)channel);
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)channel);
                }
            }

            public void registrationTerminated() {
            }
        };
    }

    public static RemoteEJBService create(Association association, RemotingTransactionService transactionService) {
        Assert.checkNotNullParam((String)"association", (Object)association);
        Assert.checkNotNullParam((String)"transactionService", (Object)transactionService);
        return new RemoteEJBService(association, transactionService);
    }

    public OpenListener getOpenListener() {
        return this.openListener;
    }

    public void serverUp() {
        this.callbackBuffer.activate();
    }
}

