/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.Collection;
import java.util.List;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.util.BeginInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.CacheCommandInitializer;
import org.infinispan.hibernate.cache.commons.util.EndInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.util.ByteString;

public class NonTxPutFromLoadInterceptor
extends BaseCustomAsyncInterceptor {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(NonTxPutFromLoadInterceptor.class);
    private final ByteString cacheName;
    private final PutFromLoadValidator putFromLoadValidator;
    @Inject
    private CacheCommandInitializer commandInitializer;
    @Inject
    private RpcManager rpcManager;
    @Inject
    private DistributionManager distributionManager;
    private RpcOptions asyncUnordered;

    public NonTxPutFromLoadInterceptor(PutFromLoadValidator putFromLoadValidator, ByteString cacheName) {
        this.putFromLoadValidator = putFromLoadValidator;
        this.cacheName = cacheName;
    }

    @Start
    public void start() {
        this.asyncUnordered = this.rpcManager.getRpcOptionsBuilder(ResponseMode.ASYNCHRONOUS, DeliverOrder.NONE).build();
    }

    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (!ctx.isOriginLocal() && command instanceof BeginInvalidationCommand) {
            for (Object key : command.getKeys()) {
                this.putFromLoadValidator.beginInvalidatingKey(((BeginInvalidationCommand)command).getLockOwner(), key);
            }
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public void endInvalidating(Object key, Object lockOwner, boolean successful) {
        assert (lockOwner != null);
        if (!this.putFromLoadValidator.endInvalidatingKey(lockOwner, key, successful)) {
            log.failedEndInvalidating(key, this.cacheName);
        }
        EndInvalidationCommand endInvalidationCommand = this.commandInitializer.buildEndInvalidationCommand(this.cacheName, new Object[]{key}, lockOwner);
        List members = this.distributionManager.getCacheTopology().getMembers();
        this.rpcManager.invokeRemotely((Collection)members, (ReplicableCommand)endInvalidationCommand, this.asyncUnordered);
    }
}

