/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Address;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class MessageID
implements Comparable<MessageID>,
Cloneable,
SizeStreamable {
    private Address address = null;
    private long id = -1L;

    public MessageID() {
    }

    public MessageID(Address address, long id) {
        this.address = address;
        this.id = id;
    }

    @Override
    public int compareTo(MessageID other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return this.id == other.id ? this.address.compareTo(other.address) : (this.id < other.id ? -1 : 1);
    }

    public Address getAddress() {
        return this.address;
    }

    public String toString() {
        return "MessageID{" + this.address + ":" + this.id + "}";
    }

    public Object clone() {
        try {
            MessageID dolly = (MessageID)super.clone();
            dolly.address = this.address;
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageID messageID = (MessageID)o;
        return this.id == messageID.id && !(this.address == null ? messageID.address != null : !this.address.equals(messageID.address));
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    @Override
    public int serializedSize() {
        return Bits.size(this.id) + Util.size(this.address);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Util.writeAddress(this.address, out);
        Bits.writeLong(this.id, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.address = Util.readAddress(in);
        this.id = Bits.readLong(in);
    }
}

