/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class ThreadFactoryAdd
extends AbstractAddStepHandler {
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.GROUP_NAME, PoolAttributeDefinitions.THREAD_NAME_PATTERN, PoolAttributeDefinitions.PRIORITY};
    static final AttributeDefinition[] RW_ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.GROUP_NAME, PoolAttributeDefinitions.THREAD_NAME_PATTERN, PoolAttributeDefinitions.PRIORITY};
    static final ThreadFactoryAdd INSTANCE = new ThreadFactoryAdd();

    private ThreadFactoryAdd() {
        super(ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode priorityModelNode = PoolAttributeDefinitions.PRIORITY.resolveModelAttribute(context, model);
        ModelNode groupNameModelNode = PoolAttributeDefinitions.GROUP_NAME.resolveModelAttribute(context, model);
        ModelNode threadNamePatternModelNode = PoolAttributeDefinitions.THREAD_NAME_PATTERN.resolveModelAttribute(context, model);
        String threadNamePattern = threadNamePatternModelNode.isDefined() ? threadNamePatternModelNode.asString() : null;
        Integer priority = priorityModelNode.isDefined() ? new Integer(priorityModelNode.asInt()) : null;
        String groupName = groupNameModelNode.isDefined() ? groupNameModelNode.asString() : null;
        String name = context.getCurrentAddressValue();
        ServiceTarget target = context.getServiceTarget();
        ThreadFactoryService service = new ThreadFactoryService();
        service.setNamePattern(threadNamePattern);
        service.setPriority(priority);
        service.setThreadGroupName(groupName);
        target.addService(ThreadsServices.threadFactoryName(name), (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

