/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FullTextFilterDefMapping;
import org.hibernate.search.cfg.IndexedMapping;
import org.hibernate.search.cfg.NormalizerDefMapping;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.ProvidedIdMapping;
import org.hibernate.search.cfg.SearchMapping;

public class IndexedClassBridgeMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;
    private final Map<String, Object> classBridge;
    private final IndexedMapping indexedMapping;

    public IndexedClassBridgeMapping(SearchMapping mapping, EntityDescriptor entity, Class<?> impl, IndexedMapping indexedMapping) {
        this(mapping, entity, indexedMapping);
        entity.addClassBridgeDef(this.classBridge);
        if (impl != null) {
            this.classBridge.put("impl", impl);
        }
    }

    public IndexedClassBridgeMapping(SearchMapping mapping, EntityDescriptor entity, FieldBridge instance, IndexedMapping indexedMapping) {
        this(mapping, entity, indexedMapping);
        entity.addClassBridgeInstanceDef(instance, this.classBridge);
        this.classBridge.put("impl", Void.TYPE);
    }

    private IndexedClassBridgeMapping(SearchMapping mapping, EntityDescriptor entity, IndexedMapping indexedMapping) {
        this.mapping = mapping;
        this.entity = entity;
        this.indexedMapping = indexedMapping;
        this.classBridge = new HashMap<String, Object>();
    }

    public IndexedClassBridgeMapping name(String name) {
        this.classBridge.put("name", name);
        return this;
    }

    public IndexedClassBridgeMapping store(Store store) {
        this.classBridge.put("store", (Object)store);
        return this;
    }

    public IndexedClassBridgeMapping index(Index index) {
        this.classBridge.put("index", (Object)index);
        return this;
    }

    public IndexedClassBridgeMapping analyze(Analyze analyze) {
        this.classBridge.put("analyze", (Object)analyze);
        return this;
    }

    public IndexedClassBridgeMapping norms(Norms norms) {
        this.classBridge.put("norms", (Object)norms);
        return this;
    }

    public IndexedClassBridgeMapping termVector(TermVector termVector) {
        this.classBridge.put("termVector", (Object)termVector);
        return this;
    }

    public IndexedClassBridgeMapping boost(float boost) {
        HashMap<String, Float> boostAnn = new HashMap<String, Float>();
        boostAnn.put("value", Float.valueOf(boost));
        this.classBridge.put("boost", boostAnn);
        return this;
    }

    public IndexedClassBridgeMapping analyzer(Class<?> analyzerClass) {
        HashMap analyzer = new HashMap();
        analyzer.put("impl", analyzerClass);
        this.classBridge.put("analyzer", analyzer);
        return this;
    }

    public IndexedClassBridgeMapping analyzer(String analyzerDef) {
        HashMap<String, String> analyzer = new HashMap<String, String>();
        analyzer.put("definition", analyzerDef);
        this.classBridge.put("analyzer", analyzer);
        return this;
    }

    public IndexedClassBridgeMapping param(String name, String value) {
        Map<String, Object> param = SearchMapping.addElementToAnnotationArray(this.classBridge, "params");
        param.put("name", name);
        param.put("value", value);
        return this;
    }

    public IndexedClassBridgeMapping classBridge(Class<?> impl) {
        return new IndexedClassBridgeMapping(this.mapping, this.entity, impl, this.indexedMapping);
    }

    public IndexedClassBridgeMapping classBridgeInstance(FieldBridge instance) {
        return new IndexedClassBridgeMapping(this.mapping, this.entity, instance, this.indexedMapping);
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this.mapping, name, impl);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return this.analyzerDef(name, "", tokenizerFactory);
    }

    public AnalyzerDefMapping analyzerDef(String name, String tokenizerName, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerName, tokenizerFactory, this.mapping);
    }

    public NormalizerDefMapping normalizerDef(String name) {
        return new NormalizerDefMapping(name, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public ProvidedIdMapping providedId() {
        return new ProvidedIdMapping(this.mapping, this.entity);
    }
}

