/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.sshtools.j2ssh.util.Base64;

public class OpenSSHPublicKeyFormat
implements SshPublicKeyFormat {
    String comment = null;

    public OpenSSHPublicKeyFormat(String string) {
        this.setComment(string);
    }

    public OpenSSHPublicKeyFormat() {
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFormatType() {
        return "OpenSSH-PublicKey";
    }

    public byte[] getKeyBlob(byte[] byArray) throws InvalidSshKeyException {
        int n;
        String string;
        String string2 = new String(byArray);
        int n2 = string2.indexOf(" ");
        if (n2 > 0 && this.supportsAlgorithm(string = string2.substring(0, n2)) && (n = string2.indexOf(" ", n2 + 1)) > n2) {
            String string3 = string2.substring(n2 + 1, n);
            if (string2.length() > n) {
                this.comment = string2.substring(n + 1).trim();
            }
            return Base64.decode(string3);
        }
        throw new InvalidSshKeyException("Failed to read OpenSSH key format");
    }

    public byte[] formatKey(byte[] byArray) {
        String string = ByteArrayReader.readString(byArray, 0);
        String string2 = string + " " + Base64.encodeBytes(byArray, true);
        if (this.comment != null) {
            string2 = string2 + " " + this.comment;
        }
        return string2.getBytes();
    }

    public boolean isFormatted(byte[] byArray) {
        String string = new String(byArray).trim();
        return string.startsWith("ssh-dss") || string.startsWith("ssh-rsa");
    }

    public boolean supportsAlgorithm(String string) {
        return string.equals("ssh-dss") || string.equals("ssh-rsa");
    }
}

