/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.data_service;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import scs.core.ComponentId;
import tecgraf.openbus.data_service.InvalidDataKey;

public final class DataKey {
    private static final int BUFFER_SIZE = 1024;
    private static final String CHARSET_NAME = "UTF8";
    static final String COMPONENT_ID_SEPARATOR = ":";
    static final String COMPONENT_ID_VERSION_SEPARATOR = ".";
    private byte[] key;
    private String dataId;
    private String serviceInterfaceName;
    private ComponentId serviceComponentId;
    private String serviceFacetName;
    private String serviceFacetIOR;

    public DataKey(byte[] key) throws InvalidDataKey {
        ByteBuffer buffer = ByteBuffer.wrap(key);
        try {
            this.dataId = DataKey.readString(buffer);
            this.serviceInterfaceName = DataKey.readString(buffer);
            this.serviceComponentId = DataKey.generateComponentId(DataKey.readString(buffer));
            this.serviceFacetName = DataKey.readString(buffer);
            this.serviceFacetIOR = DataKey.readString(buffer);
            if (buffer.remaining() != 0) {
                throw new InvalidDataKey(key);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidDataKey(key);
        }
        this.key = Arrays.copyOf(key, key.length);
    }

    public DataKey(String dataId) throws InvalidDataKey {
        this(dataId, "", null, "", "");
    }

    public DataKey(String dataId, String serviceInterfaceName, ComponentId serviceComponentId, String serviceFacetName, String serviceFacetIOR) throws InvalidDataKey {
        if (dataId == null) {
            throw new IllegalArgumentException("O identificador real do dado n\u00e3o pode ser nulo.");
        }
        this.dataId = dataId;
        this.serviceInterfaceName = serviceInterfaceName == null ? "" : serviceInterfaceName;
        this.serviceComponentId = serviceComponentId;
        this.serviceFacetName = serviceFacetName == null ? "" : serviceFacetName;
        this.serviceFacetIOR = serviceFacetIOR == null ? "" : serviceFacetIOR;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        try {
            DataKey.putString(buffer, this.dataId);
            DataKey.putString(buffer, this.serviceInterfaceName);
            DataKey.putString(buffer, DataKey.generateComponentIdString(this.serviceComponentId));
            DataKey.putString(buffer, this.serviceFacetName);
            DataKey.putString(buffer, this.serviceFacetIOR);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidDataKey();
        }
        buffer.flip();
        this.key = new byte[buffer.limit()];
        buffer.get(this.key);
    }

    private static String readString(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        int valueLength = byteBuffer.getInt();
        byte[] value = new byte[valueLength];
        byteBuffer.get(value);
        return new String(value, CHARSET_NAME);
    }

    private static void putString(ByteBuffer byteBuffer, String value) throws UnsupportedEncodingException {
        byte[] valueBytes = value.getBytes(CHARSET_NAME);
        byteBuffer.putInt(valueBytes.length);
        byteBuffer.put(valueBytes);
    }

    private static ComponentId generateComponentId(String componentIdString) {
        if (componentIdString.equals("")) {
            return null;
        }
        String[] splittedComponentId = componentIdString.split(COMPONENT_ID_SEPARATOR);
        String[] splittedVersion = splittedComponentId[1].split("\\.");
        return new ComponentId(splittedComponentId[0], Byte.parseByte(splittedVersion[0]), Byte.parseByte(splittedVersion[1]), Byte.parseByte(splittedVersion[2]), null);
    }

    private static String generateComponentIdString(ComponentId componentId) {
        if (componentId == null) {
            return "";
        }
        return componentId.name + COMPONENT_ID_SEPARATOR + componentId.major_version + COMPONENT_ID_VERSION_SEPARATOR + componentId.minor_version + COMPONENT_ID_VERSION_SEPARATOR + componentId.patch_version;
    }

    public String getDataId() {
        return this.dataId;
    }

    public String getServiceInterfaceName() {
        return this.serviceInterfaceName;
    }

    public ComponentId getServiceComponentId() {
        return this.serviceComponentId;
    }

    public String getServiceFacetName() {
        return this.serviceFacetName;
    }

    public String getServiceFacetIOR() {
        return this.serviceFacetIOR;
    }

    public byte[] getKey() {
        return this.key;
    }
}

