/*
 * Decompiled with CFR 0.152.
 */
package demo.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.CurrentHelper;
import org.omg.PortableInterceptor.InvalidSlot;
import tecgraf.openbus.exception.OpenBusInternalException;

public class ContextInspector
extends LocalObject {
    private static final Logger logger = Logger.getLogger(ContextInspector.class.getName());
    public static final String INITIAL_REFERENCE_ID = ContextInspector.class.getSimpleName();
    private ORB orb;
    private int mySlotId;
    private Codec codec;
    private int serviceContextId;

    ContextInspector(int mySlotId, Codec codec) {
        this.mySlotId = mySlotId;
        this.codec = codec;
    }

    int getMySlotId() {
        return this.mySlotId;
    }

    Codec getCodec() {
        return this.codec;
    }

    void setORB(ORB orb) {
        this.orb = orb;
    }

    public ORB getORB() {
        return this.orb;
    }

    void setContextId(int id) {
        this.serviceContextId = id;
    }

    int getContextId() {
        return this.serviceContextId;
    }

    private Current getPICurrent(ORB orb) throws OpenBusInternalException {
        Object obj;
        try {
            obj = orb.resolve_initial_references("PICurrent");
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao obter o PICurrent";
            throw new OpenBusInternalException(message, (Throwable)e);
        }
        return CurrentHelper.narrow((Object)obj);
    }

    public String getContextInformation() {
        Current current = this.getPICurrent(this.orb);
        try {
            Any any = current.get_slot(this.mySlotId);
            if (any.type().kind().value() == 0) {
                return null;
            }
            return any.extract_string();
        }
        catch (InvalidSlot e) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel recuperar informa\u00e7\u00e3o no slotId", e);
        }
    }

    public void setContextInformation(String info) {
        Current current = this.getPICurrent(this.orb);
        Any any = this.orb.create_any();
        if (info != null) {
            any.insert_string(info);
        }
        try {
            current.set_slot(this.mySlotId, any);
        }
        catch (InvalidSlot e) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel salvar informa\u00e7\u00e3o no slotId", e);
        }
    }

    public void clearContextInformation() {
        this.setContextInformation(null);
    }

    public static ContextInspector getContextInspector(ORB orb) {
        Object obj;
        try {
            obj = orb.resolve_initial_references(INITIAL_REFERENCE_ID);
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao obter o inspetor de contexto";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
        if (obj == null) {
            String message = "O inspetor de contexto n\u00e3o foi encontrado";
            logger.severe(message);
            throw new INITIALIZE(message);
        }
        return (ContextInspector)obj;
    }
}

