/*
 * Decompiled with CFR 0.152.
 */
package demo.interceptor;

import demo.interceptor.ClientInterceptor;
import demo.interceptor.ContextInspector;
import demo.interceptor.ServerInterceptor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public final class PersonalInitializer
extends LocalObject
implements ORBInitializer {
    private static final Logger logger = Logger.getLogger(PersonalInitializer.class.getName());
    private static final byte ENCODING_CDR_ENCAPS_MAJOR_VERSION = 1;
    private static final byte ENCODING_CDR_ENCAPS_MINOR_VERSION = 2;

    public void pre_init(ORBInitInfo info) {
        int mySlotId = info.allocate_slot_id();
        Codec codec = this.createCodec(info);
        ContextInspector inspector = new ContextInspector(mySlotId, codec);
        try {
            info.register_initial_reference(ContextInspector.INITIAL_REFERENCE_ID, (Object)inspector);
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao registrar o inspetor de contexto";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
    }

    public void post_init(ORBInitInfo info) {
        this.addClientInterceptor(info);
        this.addServerInterceptors(info);
    }

    private void addClientInterceptor(ORBInitInfo info) {
        try {
            info.add_client_request_interceptor((ClientRequestInterceptor)new ClientInterceptor(this.getInspector(info)));
        }
        catch (DuplicateName e) {
            String message = "Falha inesperada ao registrar o interceptador cliente";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
    }

    private void addServerInterceptors(ORBInitInfo info) {
        try {
            info.add_server_request_interceptor((ServerRequestInterceptor)new ServerInterceptor(this.getInspector(info)));
        }
        catch (DuplicateName e) {
            String message = "Falha inesperada ao registrar o interceptador servidor";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
    }

    private Codec createCodec(ORBInitInfo info) {
        Object obj;
        try {
            obj = info.resolve_initial_references("CodecFactory");
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao obter a f\u00e1brica de codificadores";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
        CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)obj);
        Encoding encoding = new Encoding(0, 1, 2);
        try {
            return codecFactory.create_codec(encoding);
        }
        catch (UnknownEncoding e) {
            String message = "Falha inesperada ao criar o codificador";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
    }

    private ContextInspector getInspector(ORBInitInfo info) {
        Object obj;
        try {
            obj = info.resolve_initial_references(ContextInspector.INITIAL_REFERENCE_ID);
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao obter o inspetor";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
        if (obj == null) {
            String message = "O inspetor n\u00e3o foi encontrado";
            logger.severe(message);
            throw new INITIALIZE(message);
        }
        return (ContextInspector)obj;
    }
}

